% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mockMosaicData.R
\name{mockMosaicData}
\alias{mockMosaicData}
\title{mockMosaicData}
\usage{
mockMosaicData(
  names = c("D1", "D2", "D3"),
  ncells = c(50, 50, 50),
  ngenes = list(1:150, 76:225, 151:300),
  fun = "rnorm",
  ...
)
}
\arguments{
\item{names}{character vector of mock datasets.}

\item{ncells}{integer vector of cells in each mock dataset.}

\item{ngenes}{list containing integer vectors of features measured in each
mock dataset.}

\item{fun}{name of function to simulate data, default "rnorm".}

\item{...}{further arguments passed to `fun`.}
}
\value{
assay_list a list of data matrices with rownames (features)
specified.
}
\description{
Mock up a mosaic data list using simulated data, for use in documentation
examples.
}
\examples{
set.seed(2021)
assay_list <- mockMosaicData()
lapply(assay_list, dim)

# simulate data from another distribution
assay_list <- mockMosaicData(fun = "rnbinom", size = 5, prob = 0.5)
lapply(assay_list, dim)

}
