% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_signature.R
\name{fetch_signature}
\alias{fetch_signature}
\title{Fetch scRNAseq Signature}
\usage{
fetch_signature(tumor_type, n_celltypes)
}
\arguments{
\item{tumor_type}{string choosing the tumor type from available signatures
at: https://github.com/tgac-vumc/StatescopeData}

\item{n_celltypes}{integer choosing the number of cell types of the signature
from: https://github.com/tgac-vumc/StatescopeData}
}
\value{
SimpleList with DataFrames for Mu (mean per gene per cell type) and
Omega (variance corrected std.dev per gene per cell type) and vector of
selected genes for deconvolution chosen by AutoGeneS
}
\description{
\code{fetch_signature} Fetches signature from StatescopeData repository
}
\examples{
signature <- fetch_signature('PDAC', 7)
selected_genes <- signature$selected_genes
}
