% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Structstrings.R
\name{Structstrings}
\alias{Structstrings}
\title{Structstrings: implementation of the dot bracket annotations with 
Biostrings}
\description{
The \code{Structstrings} package implements the widely used to bracket
annotation for storing base pairing information in structured RNA. For
example it is used in the ViennaRNA package (Lorenz et al. 2011), the
tRNAscan-SE software (Lowe et al. 1997) and the tRNAdb (Jühling et al. 2009).

\code{Structstrings} uses the infrastructure provided by the
\code{Biostrings} package and derives the class
\code{\link{DotBracketString}} and such from the equivalent
\code{\link[Biostrings:XStringSet-class]{BString}} class. From these base pair table can be produced for
in depth analysis. For this purpose the \code{\link{DotBracketDataFrame}}
class is derived from the \code{\link[S4Vectors:DataFrame-class]{DataFrame}} class. In addition the loop
IDs of the base pairs can be retrieved as a \code{\link{LoopIndexList}}, a
derivate if the \code{\link[IRanges:AtomicList]{IntegerList}}. Generally, it checks automatically
for the validity of the dot bracket annotation.

The conversion of the \code{\link{DotBracketString}} to the base pair table
and the loop indices is implemented in C for efficiency. The C implementation
to a large extent inspired by the
\href{https://www.tbi.univie.ac.at/RNA/}{ViennaRNA} package.

This package was developed as a requirement for the \code{tRNA} package. 
However, other projects might benefit as well, so it was split of and 
improved upon.
}
\section{Manual}{

Please refer to the Structstrings vignette for an example how to work and 
use the package: \href{../doc/Structstrings.html}{Structstrings}.
}

\references{
Lorenz, Ronny; Bernhart, Stephan H.; Höner zu Siederdissen, Christian; Tafer,
Hakim; Flamm, Christoph; Stadler, Peter F.; Hofacker, Ivo L. (2011):
"ViennaRNA Package 2.0". Algorithms for Molecular Biology 6:26.
\href{https://doi.org/10.1186/1748-7188-6-26}{doi:10.1186/1748-7188-6-26}

Lowe, T.M.; Eddy, S.R.(1997): "tRNAscan-SE: A program for improved detection
of transfer RNA genes in genomic sequence". Nucl. Acids Res. 25: 955-964.
\href{https://doi.org/10.1093/nar/25.5.955}{doi:10.1093/nar/25.5.955}

Jühling, Frank; Mörl, Mario; Hartmann, Roland K.; Sprinzl, Mathias; Stadler,
Peter F.; Pütz, Joern (2009): "TRNAdb 2009: Compilation of tRNA Sequences and
tRNA Genes." Nucleic Acids Research 37 (suppl_1): D159–D162.
\href{https://doi.org/10.1093/nar/gkn772}{doi:10.1093/nar/gkn772}.
}
\author{
Felix G M Ernst [aut,cre]
}
