% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svmClassifier.R
\name{svmClassification}
\alias{svmClassification}
\title{Protein subcellular localization classification}
\usage{
svmClassification(markerProteins, protein.data, markerprot.df)
}
\arguments{
\item{markerProteins}{character; robust marker proteins along
with subcellular localization that are present in the given data.}

\item{protein.data}{data.frame; fractionated proteomics data}

\item{markerprot.df}{data.frame; collection of marker proteins
along with corresponding subcellular localization}
}
\value{
all.classifications
}
\description{
Support Vector Machine classifier is trained and
used for prediction of protein subcellular localization
}
\examples{
{

df <- loadData(SubCellBarCode::hcc827Ctrl)

c.prots <- calculateCoveredProtein(rownames(df), markerProteins[,1])

set.seed(7)
c.prots <- sample(c.prots, 500)
cls <- svmClassification(c.prots, df, markerProteins)

}
}
