% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TsIO_classes.R
\name{accessors}
\alias{accessors}
\alias{sequence_id}
\alias{sequence_id<-}
\alias{target_sequence}
\alias{target_sequence<-}
\alias{beads_oligo}
\alias{beads_oligo<-}
\alias{reverse_primer}
\alias{reverse_primer<-}
\alias{target_annot}
\alias{target_annot<-}
\alias{product_size_range}
\alias{product_size_range<-}
\alias{primer_num_return}
\alias{primer_num_return<-}
\alias{min_primer_region}
\alias{min_primer_region<-}
\alias{primer_opt_tm}
\alias{primer_opt_tm<-}
\alias{primer_min_tm}
\alias{primer_min_tm<-}
\alias{primer_max_tm}
\alias{primer_max_tm<-}
\alias{sequence_template}
\alias{tapseq_primers}
\alias{pcr_products}
\title{Accessors for TsIO objects}
\usage{
sequence_id(x)

sequence_id(x) <- value

target_sequence(x)

target_sequence(x) <- value

beads_oligo(x)

beads_oligo(x) <- value

reverse_primer(x)

reverse_primer(x) <- value

target_annot(x)

target_annot(x) <- value

product_size_range(x)

product_size_range(x) <- value

primer_num_return(x)

primer_num_return(x) <- value

min_primer_region(x)

min_primer_region(x) <- value

primer_opt_tm(x)

primer_opt_tm(x) <- value

primer_min_tm(x)

primer_min_tm(x) <- value

primer_max_tm(x)

primer_max_tm(x) <- value

sequence_template(x)

tapseq_primers(x)

pcr_products(x)
}
\arguments{
\item{x}{A \code{TsIO} or \code{TsIOList} class object.}

\item{value}{A valid value to assign to the chosen slot.}
}
\value{
Returns the stored value(s) of a slot, or sets a new value
}
\description{
A set of functions for getting/setting/modifying the data stored in
\code{\link[TAPseq:TsIO-class]{TsIO}} or \code{\link[TAPseq:TsIOList-class]{TsIOList}} class
objects.
}
\examples{
# chr11 primers example data
data("chr11_primers")

# slot values of TsIO objects can be accessed using accessor functions
tsio <- chr11_primers[[1]]
sequence_id(tsio)
sequence_id(tsio) <- "Gene1"
sequence_id(tsio)

# some slots can only be obtained, but not set as filling these is part of the TAPseq workflow
tapseq_primers(tsio)
pcr_products(tsio)

# sequence templates can be created
sequence_template(tsio)

# values of TsIOList object slots can be extracted as well, but not set
tsio_list <- chr11_primers[1:2]
sequence_id(tsio_list)
target_sequence(tsio_list)
target_annot(tsio_list)
tapseq_primers(tsio_list)
pcr_products(tsio_list)
sequence_template(tsio_list)
}
