% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oncoPrintTCGA.R
\name{oncoPrintTCGA}
\alias{oncoPrintTCGA}
\title{OncoPrint for TCGA Mutation Assays}
\usage{
oncoPrintTCGA(
  multiassayexperiment,
  matchassay = "*_Mutation-*",
  variantCol = "Variant_Classification",
  brewerPal = "Set3",
  ntop = 25,
  incl.thresh = 0.01,
  rowcol = "Hugo_Symbol"
)
}
\arguments{
\item{multiassayexperiment}{A \code{MultiAssayExperiment}, usually from
\code{curatedTCGAData}}

\item{matchassay}{character(1) The name of the assay containing mutation
data, this can be a pattern (e.g., "\emph{_Mutation-}", the default)}

\item{variantCol}{character(1) The name of the metadata column containing
the mutation categories, usually "Variant_Classification" in TCGA}

\item{brewerPal}{character(1) The name of the \code{RColorBrewer::brewer.pal}
palette, (default: "Set3")}

\item{ntop}{integer(1) The number of the top N genes for displaying based
on per-sample mutation frequency}

\item{incl.thresh}{double(1) The inclusion threshold for empirical mutations,
mutations less frequent than this value will not be included}

\item{rowcol}{character(1) The name of the column in the metadata to annotate
the rows with either "Hugo_Symbol" (default) or}
}
\value{
An oncoPrint plot of mutations
}
\description{
OncoPrint for TCGA Mutation Assays
}
\examples{

library(curatedTCGAData)

acc <- curatedTCGAData("ACC", "Mutation", version = "1.1.38", FALSE)

oncoPrintTCGA(acc)

}
