% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplifyColData.R
\name{trimColData}
\alias{trimColData}
\title{Minimize the number of variables in colData}
\usage{
trimColData(
  multiassayexperiment,
  maxNAfrac = 0.2,
  keystring = c("portion", "analyte")
)
}
\arguments{
\item{multiassayexperiment}{A
\code{\link[MultiAssayExperiment:MultiAssayExperiment-class]{MultiAssayExperiment}}
object with \code{colData}}

\item{maxNAfrac}{(numeric default 0.2) A decimal between 0 and 1 to indicate
the amount of NA values allowed per column}

\item{keystring}{(character) A vector of keywords to match and remove
variables}
}
\value{
A
\code{\link[MultiAssayExperiment:MultiAssayExperiment-class]{MultiAssayExperiment}}
object
}
\description{
This function removes variables that have a high number of missing data
and contain keywords.
}
\examples{

example(getSubtypeMap)

(gbm_trimmed <- trimColData(gbm))

head(colData(gbm_trimmed))[1:5]

}
