% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step5OptimizeLinks.R
\name{step5OptimizeLinks}
\alias{step5OptimizeLinks}
\title{Find final RE DNA methylation site-gene links using various optimization
metrics}
\usage{
step5OptimizeLinks(
  TENETMultiAssayExperiment,
  hypermethGplusAnalysis = TRUE,
  hypomethGplusAnalysis = TRUE,
  expressionPvalCutoff = 0.05,
  hyperStringency = NA,
  hypoStringency = NA,
  coreCount = 1
)
}
\arguments{
\item{TENETMultiAssayExperiment}{Specify a MultiAssayExperiment object
containing expression and methylation SummarizedExperiment objects, such
as one created by the TCGADownloader function. The object's metadata must
contain the results from the \code{step2GetDifferentiallyMethylatedSites},
\code{step3GetAnalysisZScores}, and
\code{step4SelectMostSignificantLinksPerDNAMethylationSite} functions.}

\item{hypermethGplusAnalysis}{Set to TRUE to optimize hypermethylated
G+ links. Requires \code{hypermethAnalysis} to have been set to TRUE in step 4.}

\item{hypomethGplusAnalysis}{Set to TRUE to optimize hypomethylated
G+ links. Requires \code{hypomethAnalysis} to have been set to TRUE in step 4.}

\item{expressionPvalCutoff}{Cutoff for Benjamini-Hochberg corrected
Wilcoxon p-values used during comparison of gene expression values between
hyper/hypomethylated case and control samples. Defaults to 0.05.}

\item{hyperStringency}{Specify a beta-value cutoff as a number from 0 to 1 to
select hypermethylated links with methylation values above the cutoff.
Defaults to the \code{hypermethCutoff} value specified in step 2.}

\item{hypoStringency}{Specify a beta-value cutoff as a number from 0 to 1 to
select hypomethylated links with methylation values below the cutoff.
Defaults to the \code{hypomethCutoff} value specified in step 2.}

\item{coreCount}{Argument passed as the mc.cores argument to mcmapply.
See \code{?parallel::mcmapply} for more details. Defaults to 1.}
}
\value{
Returns the MultiAssayExperiment object given as the
TENETMultiAssayExperiment argument with an additional list named
"step5OptimizeLinks" in its metadata containing the output of this function,
which includes the gene and RE DNA methylation site IDs of each optimized
gene-RE DNA methylation site link, the Z-scores and corresponding p-values
calculated in steps 3-4 for those links, and the various optimization
metrics calculated by this step.
}
\description{
This function takes the most significant hyper- and/or hypomethylated G+ RE
DNA methylation site-gene links selected in step 4, and selects optimized
links based on the relative expression of the given gene in hyper- or
hypomethylated case samples compared to control samples, using an unpaired
two-sided Wilcoxon rank-sum test to check that the hyper- or hypomethylated
samples for that given RE DNA methylation site-gene link also show
appropriately higher/lower expression of the linked gene in a number of case
samples greater than or equal to the \code{minCaseCount} number specified in the
\code{step2GetDifferentiallyMethylatedSites} function that have maximum/minimum
methylation above/below the \code{hyperStringency}/\code{hypoStringency} cutoff values
selected.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
## This example uses the example MultiAssayExperiment provided in the
## TENET.ExperimentHub package to optimize links between the hypermethylated
## and hypomethylated RE DNA methylation sites and the expression of
## transcription factor genes. The default p-value cutoff of 0.05 is used,
## and the `hyperStringency` and `hypoStringency` values are set to the
## originally calculated hyper- and hypomethylation cutoffs. The analysis
## uses one CPU core.

## Load the example TENET MultiAssayExperiment object
## from the TENET.ExperimentHub package
exampleTENETMultiAssayExperiment <-
    TENET.ExperimentHub::exampleTENETMultiAssayExperiment()

## Perform the link optimization
returnValue <- step5OptimizeLinks(
    TENETMultiAssayExperiment = exampleTENETMultiAssayExperiment
)

## This example demonstrates many of the analysis options. It only runs
## on hypomethylated RE DNA methylation sites and uses an expression p-value
## cutoff of 0.01. The `hypoStringency` value is set to 0.3, overriding the
## hypomethylation cutoff set in step 2. The analysis uses eight CPU cores.

## Load the example TENET MultiAssayExperiment object
## from the TENET.ExperimentHub package
exampleTENETMultiAssayExperiment <-
    TENET.ExperimentHub::exampleTENETMultiAssayExperiment()

## Perform the link optimization
returnValue <- step5OptimizeLinks(
    TENETMultiAssayExperiment = exampleTENETMultiAssayExperiment,
    hypermethGplusAnalysis = FALSE,
    expressionPvalCutoff = 0.01,
    hypoStringency = 0.3,
    coreCount = 8
)
\dontshow{\}) # examplesIf}
}
