% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/step7SelectedDNAMethylationSitesCaseVsControlBoxplots.R
\name{step7SelectedDNAMethylationSitesCaseVsControlBoxplots}
\alias{step7SelectedDNAMethylationSitesCaseVsControlBoxplots}
\title{Generate boxplots or violin plots comparing the methylation level of the
specified RE DNA methylation sites in case and control samples}
\usage{
step7SelectedDNAMethylationSitesCaseVsControlBoxplots(
  TENETMultiAssayExperiment,
  DNAMethylationSites,
  violinPlots = FALSE,
  coreCount = 1
)
}
\arguments{
\item{TENETMultiAssayExperiment}{Specify a MultiAssayExperiment object
containing a methylation SummarizedExperiment object, such as one created by
the TCGADownloader function.}

\item{DNAMethylationSites}{Supply a vector of RE DNA methylation site IDs
for which to create boxplots or violin plots with the methylation of those RE
DNA methylation sites.}

\item{violinPlots}{Set to TRUE to generate violin plots instead of boxplots.
Defaults to FALSE.}

\item{coreCount}{Argument passed as the mc.cores argument to mcmapply. See
\code{?parallel::mcmapply} for more details. Defaults to 1.}
}
\value{
Returns the MultiAssayExperiment object given as the
TENETMultiAssayExperiment argument with an additional list named
'step7SelectedDNAMethylationSitesCaseVsControlBoxplots' in its metadata,
which contains boxplots or violin plots comparing the methylation of the RE
DNA methylation sites of interest in the case and control samples. The titles
of the plots contain the ID of the RE DNA methylation site and the Student's
t-test p-value.
}
\description{
This function takes a vector of RE DNA methylation sites specified by the
user and generates boxplots or violin plots displaying the methylation level
of each of these DNA methylation sites in the case compared to control
samples, along with the results of a Student's t-test comparing the
methylation level between these two groups.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
## This example uses the example MultiAssayExperiment provided in the
## TENET.ExperimentHub package to generate boxplots for several selected
## RE DNA methylation sites, using one CPU core.

## Load the example TENET MultiAssayExperiment object
## from the TENET.ExperimentHub package
exampleTENETMultiAssayExperiment <-
    TENET.ExperimentHub::exampleTENETMultiAssayExperiment()

## Use the example dataset to create the boxplots
returnValue <- step7SelectedDNAMethylationSitesCaseVsControlBoxplots(
    TENETMultiAssayExperiment = exampleTENETMultiAssayExperiment,
    DNAMethylationSites = c("cg03095778", "cg24011501", "cg12989041"),
    coreCount = 1
)
\dontshow{\}) # examplesIf}
}
