% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genemodel2.R
\name{genemodelDF}
\alias{genemodelDF}
\title{use EnsDb to generate an exon-level model of genes identified by symbol}
\usage{
genemodelDF(sym, resource, columnsKept = c("gene_id", "tx_id"), ...)
}
\arguments{
\item{sym}{a character() vector of gene symbols}

\item{resource}{should be or inherit from EnsDb,
answering exons(), with AnnotationFilter::SymbolFilter
as filter parameter}

\item{columnsKept}{character vector used as \code{columns} param in exons()}

\item{\dots}{passed to exons()}
}
\value{
data.frame instance with exons in rows
}
\description{
use EnsDb to generate an exon-level model of genes identified by symbol
}
\note{
There are many approaches available to acquiring 'gene models'
in Bioconductor; this one emphasizes the use of the exons method
for Ensembl annotation.
}
\examples{
if (requireNamespace("EnsDb.Hsapiens.v75")) {
 orm = genemodelDF("ORMDL3", EnsDb.Hsapiens.v75::EnsDb.Hsapiens.v75)
 dim(orm)
}
head(orm)
}
