% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extendRangeNum.R
\name{extendRangeNum}
\alias{extendRangeNum}
\title{Extend the Range of Values Out to the Nearest Digit}
\usage{
extendRangeNum(x, nearest = 1)
}
\arguments{
\item{x}{any \code{\link[base]{numeric}} object. Passed to
\code{\link[base]{range}}.}

\item{nearest}{numeric; the range of \code{x} will be extended out to the
value specified by \code{nearest}. Default is 1, which extends the range
out to the nearest integer.}
}
\value{
A \code{numeric} vector of length 2 containing the minimum and
maximum values of \code{x} after extending them outward to the value
provided by \code{nearest}.
}
\description{
Extend the Range of Values Out to the Nearest Digit
}
\examples{
set.seed(0)
x <- runif(5, min = -10, max = 10)
range(x) # -4.689827  8.164156

extendRangeNum(x) # -5  9
extendRangeNum(x, nearest = 2) # -6  10
extendRangeNum(x, nearest = 0.1) # -4.7  8.2
}
\seealso{
\code{\link[base]{range}}, \code{\link[grDevices]{extendrange}}
}
