% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze2DTPP.R
\name{analyze2DTPP}
\alias{analyze2DTPP}
\title{Analyze a 2D-TPP experiment}
\usage{
analyze2DTPP(
  configTable,
  data = NULL,
  resultPath = NULL,
  idVar = "gene_name",
  fcStr = NULL,
  intensityStr = "signal_sum_",
  naStrs = c("NA", "n/d", "NaN", "<NA>"),
  methods = "doseResponse",
  qualColName = "qupm",
  compFc = TRUE,
  normalize = TRUE,
  addCol = NULL,
  nCores = 1,
  nonZeroCols = "qssm",
  fcTolerance = 0.1,
  r2Cutoff = 0.8,
  fcCutoff = 1.5,
  slopeBounds = c(1, 50),
  fractAbund = FALSE,
  xlsxExport = TRUE,
  plotAll = FALSE,
  plotAllR2 = FALSE,
  plotSingle = FALSE,
  trRef = NULL,
  refFcStr = "norm_rel_fc_",
  addInfo = FALSE,
  createReport = "none",
  paletteName = "Spectral",
  configFile
)
}
\arguments{
\item{configTable}{dataframe, or character object with the path to a file, 
that specifies important details of the 2D-TPP experiment. See Section 
\code{details} for instructions how to create this object.}

\item{data}{single dataframe, containing fold change measurements and 
additional annotation columns to be imported. Can be used instead of 
specifying the file path in the \code{configTable} argument.}

\item{resultPath}{location where to store dose-response curve plots and 
results table.}

\item{idVar}{character string indicating which data column provides the 
unique identifiers for each protein.}

\item{fcStr}{character string indicating which columns contain the actual 
fold change values. Those column names containing the prefix \code{fcStr} 
will be regarded as containing fold change values. Only relevant if 
\code{compFC = FALSE}.}

\item{intensityStr}{character string indicating which columns contain the actual 
sumionarea values. Those column names containing the prefix \code{intensityStr} 
will be regarded as containing sumionarea values.}

\item{naStrs}{character vector indicating missing values in the data table. 
When reading data from file, this value will be passed on to the argument 
\code{na.strings} in function \code{read.delim}.}

\item{methods}{vector of character strings that indicate which methods should be used 
for the analysis (default: c("doseResponse"), alternative: c("splineFit") or 
c("doseResponse", "splineFit"))}

\item{qualColName}{character string indicating which column can be used for 
additional quality criteria when deciding between different non-unique 
protein identifiers.}

\item{compFc}{boolean flag which indicates whether to perform fold change computation 
regarding reference column from sumionareas (default: TRUE)}

\item{normalize}{perform median normalization (default: TRUE).}

\item{addCol}{character vector indicating which additional columns to include 
from the input data}

\item{nCores}{either a numerical value given the desired number of CPUs, or 
'max' to automatically assign the maximum possible number (default).}

\item{nonZeroCols}{character string indicating a column that will be used for
filtering out zero values.}

\item{fcTolerance}{tolerance for the fcCutoff parameter. See details.}

\item{r2Cutoff}{Quality criterion on dose response curve fit.}

\item{fcCutoff}{Cutoff for highest compound concentration fold change.}

\item{slopeBounds}{Bounds on the slope parameter for dose response curve 
fitting.}

\item{fractAbund}{boolean variable, if set to TRUE additional information concerning
sumionarea fractional abundance and dmso1 vs. dmso2 of adjacent temperatures is 
added to the output table}

\item{xlsxExport}{produce results table in xlsx format and store at the 
location specified by the \code{resultPath} argument.}

\item{plotAll}{boolean value indicating whether all dose response curves should
be generated. Deactivating plotting decreases runtime.}

\item{plotAllR2}{boolean value indicating whether all dose response curves which
fulfill the demanded criteria (Rsquared, maximum plateau) should be generated. 
Deactivating plotting decreases runtime.}

\item{plotSingle}{boolean value indicating whether all dose response curves which
fulfill the demanded criteria (Rsquared, maximum plateau) should be generated. 
Deactivating plotting decreases runtime.}

\item{trRef}{character string containing a valid system path to a previously generated TPP-TR
reference object}

\item{refFcStr}{character string indicating which columns in the reference data set contain 
the fold change values}

\item{addInfo}{boolean variable, if set to TRUE additional information on counts of
stabilization and destabilization of each protein is added to the output table}

\item{createReport}{character string indicating whether a markdown report should be created
and which format it have (default: "html_document", alternative: "pdf_document" or "none")}

\item{paletteName}{color palette (see details).}

\item{configFile}{DEPRECATED}
}
\value{
A data frame in which the model results (slopes and pEC50 values) are 
 stored row-wise for each protein and administered temperatures.
}
\description{
Performs the whole analysis workflow for 2D-TPP experiment by invoking routines 
  for data import, data processing, fold change computation, median normalization, 
  TPP-CCR curve fitting, plotting and production of the result table.
}
\details{
Invokes the following steps: \enumerate{ \item Import data using the
  \code{\link{tpp2dImport}} function. \item Remove zero sumionarea values. 
  \item Compute fold changes from raw data (sumionarea) 
  \item Perform normalization by fold 
  change medians (optional) using the \code{\link{tpp2dNormalize}} function.
  To perform normalization, set argument \code{normalize=TRUE}.}
 \code{paletteName} specifies the color palette to be used by the \code{\link{brewer.pal}} 
function from the \code{RColorBrewer} package to assign a separate color to 
each concentration.
}
\examples{
data(panobinostat_2DTPP_smallExample)
config_tpp2d <- panobinostat_2DTPP_config
data_tpp2d <- panobinostat_2DTPP_data
tpp2dResults <- analyze2DTPP(configTable = config_tpp2d, 
                             data = data_tpp2d,
                             methods=c("doseResponse"),
                             createReport="none",
                             nCores=1,
                             idVar = "representative",
                             addCol = "clustername",
                             intensityStr = "sumionarea_protein_",
                             nonZeroCols = "qusm")

}
\references{
Becher, I., Werner, T., Doce, C., Zaal, E. A., Berkers, C. R., T"ogel, I., 
Salzer, E., Bantscheff, M., Savitski, M. M. (2016) 
Thermal profiling reveals phenylalanine hydroxylase as an off-target of panobinostat.
Nature Chemical Biology, 12(11), 908-910.
}
