% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_invariance.R
\name{rank_invariance}
\alias{rank_invariance}
\title{Calculate the Rank Invariance of Each Gene from Cell and Group Ranks}
\usage{
rank_invariance(group_rank, cell_rank)
}
\arguments{
\item{group_rank}{A \code{data.frame()} created with \code{rank_group()}.}

\item{cell_rank}{A \code{data.frame()} created with \code{rank_cells()}.}
}
\value{
A \code{numeric()} with the rank of invariance for each gene. High values
represent low Rank Invariance, these genes are considered good candidate TREGs.
}
\description{
This function computes the Rank Invariance value for each gene, from the cell
and group ranks  computed by \code{rank_cells()} and \code{rank_group()} respectively.
Genes with high RI values are considered good candidate TREGs.
}
\examples{
## Get the rank of the gene in each group
group_rank_test <- rank_group(sce_zero_test, group_col = "group")

## Get the rank of the gene for each cell
cell_rank_test <- rank_cells(sce_zero_test, group_col = "group")

## Use both rankings to calculate rank_invariance
rank_invar_test <- rank_invariance(group_rank_test, cell_rank_test)
## Highest RI value is best candidate TREG
sort(rank_invar_test, decreasing = TRUE)
}
\seealso{
Other invariance functions: 
\code{\link{rank_cells}()},
\code{\link{rank_group}()},
\code{\link{rank_invariance_express}()}
}
\concept{invariance functions}
