% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tntTracks-compositeTrack.R
\name{composite-track}
\alias{composite-track}
\alias{merge-track}
\alias{merge,TnTTrack,TnTTrack-method}
\alias{merge,TnTTrack,missing-method}
\title{Composite Track}
\usage{
\S4method{merge}{TnTTrack,TnTTrack}(x, y, ...)

\S4method{merge}{TnTTrack,missing}(x, y, ...)
}
\arguments{
\item{x, y, ...}{Track constructed with \link{track-constructors} or composite track.}
}
\value{
Returns a "CompositeTrack" object.
}
\description{
Two or more arbitrary tracks can be used to create a composite track, by which
different features can be shown in the same track.
}
\examples{
gr <- GRanges("chr1", IRanges(c(11000, 20000, 60000), width = 2000))
gpos <- GRanges("chr1", IRanges(c(12000, 21000, 61000), width = 1), value = c(1, 2, 3))
btrack <- BlockTrack(gr, label = "Block Track", tooltip = as.data.frame(gr), color = "lightblue4")
ptrack <- PinTrack(gpos, label = "Pin Track", tooltip = as.data.frame(gpos), background = "beige")

ctrack <- merge(btrack, ptrack)
\dontrun{
TnTBoard(ctrack)
}
}
\seealso{
\url{http://tnt.marlin.pub/articles/examples/track-CompositeTrack.html}
}
