% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{mapcol}
\alias{mapcol}
\title{Scale Qualitative Values to Color}
\usage{
mapcol(value, palette.fun = grDevices::rainbow, ...)
}
\arguments{
\item{value}{A factor or character vector that may have n unique values.}

\item{palette.fun}{The palette function to generate colors.
For example, \code{\link[grDevices]{terrain.colors}}.}

\item{...}{Extra arguments passed to the palette function.}
}
\value{
A character vector as colors, with the same length of \code{value}. Same values
    in \code{value} will have the same color.
}
\description{
A simple util function that scales a factor to color based on the palette function.
}
\examples{
mapcol(iris$Species)
}
