% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trackWidget.R
\name{trackWidget}
\alias{trackWidget}
\title{Convert a TnTBoard to htmlwidget}
\usage{
trackWidget(tntdef, elementId = NULL)
}
\arguments{
\item{tntdef}{A TnTBoard/TnTGenome object or a htmlwidget object. If it is
a htmlwidget object, the function will return it as is.}

\item{elementId}{An id for the htmlwidget (random by default).}
}
\value{
The function returns a htmlwidget object.
}
\description{
This function is only provided for users who are familiar with the concept of
\link[htmlwidgets]{htmlwidgets-package}. It explicitly convets a TnTBoard or
TnTGenome object to a htmlwidget object. You do not need it in most cases.
}
\examples{
b <- TnTBoard(BlockTrack(GRanges("chr12", IRanges(1, 123))))
widget <- trackWidget(b)
class(widget)
identical(widget, trackWidget(widget))
}
