% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defineMSTPaths.R
\name{defineMSTPaths}
\alias{defineMSTPaths}
\title{Define paths through the MST}
\usage{
defineMSTPaths(g, roots, times = NULL, clusters = NULL, use.median = FALSE)
}
\arguments{
\item{g}{A \link{graph} object containing a minimum spanning tree, e.g., from \code{\link{createClusterMST}}.}

\item{roots}{A character vector specifying the root node for each component in \code{g}.}

\item{times}{A numeric vector of length equal to the number of nodes in \code{g},
specifying the external time associated with each node.
This should be named with the name of each node.
Alternatively, a numeric vector of length equal to the number of cells, in which case \code{clusters} must be specified.}

\item{clusters}{A vector or factor specifying the assigned cluster for each cell,
where each cluster corresponds to a node in \code{g}.

Alternatively, a matrix with number of rows equal to \code{nrow(x)}, 
containing soft assignment weights for each cluster (column).
All weights should be positive and sum to 1 for each row.

This only has an effect if \code{times} is set to a vector of length equal to the number of cells.}

\item{use.median}{Logical scalar indicating whether the time for each cluster is defined as the median time across its cells.
The mean is used by default.
This only has an effect if \code{clusters} is specified.}
}
\value{
A list of character vectors.
Each vector contains the names of nodes in \code{g} and defines a path through the MST from a root to an endpoint node.
}
\description{
Define paths through the MST, either from pre-specified root nodes or based on external timing information.
}
\details{
When \code{roots} is specified, a path is defined from the root to each endpoint node (i.e., with degree 1) in \code{g}.
We expect one root node to be specified for each component in \code{g}.

When \code{times} is specified, a path is defined from each local minima in time to the nearest local maxima within each component of \code{g}.
Timing information can be defined from experimental metadata or with computational methods like RNA velocity.
}
\examples{
library(igraph)
test.g <- make_graph(c("A", "B", "B", "C", "B", "D"), directed=FALSE)
defineMSTPaths(test.g, roots="A")
defineMSTPaths(test.g, roots="B")

defineMSTPaths(test.g, times=c(A=0, B=1, C=2, D=3))
defineMSTPaths(test.g, times=c(A=0, B=-1, C=2, D=3))
defineMSTPaths(test.g, times=c(A=0, B=5, C=2, D=3))

}
\seealso{
\code{\link{guessMSTRoots}}, to obtain \code{roots} without any prior information.

\code{\link{splitByBranches}}, for a root-free way of obtaining paths.
}
\author{
Aaron Lun
}
