% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_isLeaf.R
\name{isLeaf}
\alias{isLeaf}
\title{To test whether the specified nodes are leaf nodes}
\usage{
isLeaf(tree, node)
}
\arguments{
\item{tree}{A phylo object.}

\item{node}{A numeric or character vector. Node labels or node numbers.}
}
\value{
a logical vector with the same length as the input \code{node}.
}
\description{
\code{isLeaf} is to test wheter some specified nodes are leaf nodes of a
tree.
}
\examples{
data(tinyTree)
library(ggtree)

# PLOT tree
# The node labels are in orange texts and the node numbers are in blue
ggtree(tinyTree,branch.length = 'none')+
    geom_text2(aes(label = label), color = "darkorange",
           hjust = -0.1, vjust = -0.7) +
    geom_text2(aes(label = node), color = "darkblue",
               hjust = -0.5, vjust = 0.7)

isLeaf(tree = tinyTree, node = c(5, 4, 18))
isLeaf(tree = tinyTree, node = c("t4", "t9", "Node_18" ))

}
\author{
Ruizhu HUANG
}
