% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trendHeatmap.R
\name{trendHeatmap}
\alias{trendHeatmap}
\title{Draw heatmap of gene expression trends}
\usage{
trendHeatmap(topTrendyData, featureNames = NULL, cexRow = 0.5,
  cexCol = 0.5)
}
\arguments{
\item{topTrendyData}{results from topTrendy() function.}

\item{featureNames}{names of features/genes to plot if the heatmap should
be restricted. Deafult is to plot all genes from topTrendy() function.}

\item{cexRow}{relative text size of row labels, default=.5.}

\item{cexCol}{relative text size of column labels, default=.5.}
}
\value{
The function takes significant genes/features called from 
 the topTrendyData() function. These genes are further grouped into three
 groups: up, down, or no change in the first segment. Within each group,
 the genes are sorted by their first break point. The heatmap shows 
 expression trends of these three groups of genes. In the heatmap, 
 red/blue/black represents up/down/nochange. A list of genes in the heatmap
 order is returned.
}
\description{
heatmap of the fitted trends
}
\examples{
 m1 <- matrix(c(c(rnorm(50,5,1),sort(rnorm(50, 15, 5))), rnorm(100, 50,10)), 2, 100, TRUE)
 rownames(m1) <- c("g1","g2")
 colnames(m1) <- paste0("time", seq_len(100))
 myTrends <- results(trendy(m1))
 topGenes <- topTrendy(myTrends)
 #makeHeat <- trendHeatmap(topGenes)
}
\author{
Ning Leng and Rhonda Bacher
}
