% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllMethods.R
\docType{methods}
\name{dgram}
\alias{dgram}
\alias{dgram<-}
\alias{groupsUMI4C}
\alias{groupsUMI4C<-}
\alias{bait}
\alias{trend}
\alias{resultsUMI4C}
\alias{UMI4C-methods}
\alias{dgram,UMI4C-method}
\alias{dgram<-,UMI4C-method}
\alias{groupsUMI4C,UMI4C-method}
\alias{groupsUMI4C<-,UMI4C-method}
\alias{bait,UMI4C-method}
\alias{trend,UMI4C-method}
\alias{resultsUMI4C,UMI4C-method}
\title{UMI4C class methods}
\usage{
dgram(object)

dgram(object) <- value

groupsUMI4C(object, value)

groupsUMI4C(object) <- value

bait(object)

trend(object)

resultsUMI4C(object, format = "GRanges", counts = TRUE, ordered = FALSE)

\S4method{dgram}{UMI4C}(object)

\S4method{dgram}{UMI4C}(object) <- value

\S4method{groupsUMI4C}{UMI4C}(object)

\S4method{groupsUMI4C}{UMI4C}(object) <- value

\S4method{bait}{UMI4C}(object)

\S4method{trend}{UMI4C}(object)

\S4method{resultsUMI4C}{UMI4C}(object, format = "GRanges", counts = FALSE, ordered = FALSE)
}
\arguments{
\item{object}{a \code{UMI4C-class} object.}

\item{value}{Alternative list of dgrams to replace the current slot.}

\item{format}{Either "GRanges" (default) or "data.frame", indicating the
format output of the results.}

\item{counts}{Logical indicating whether counts for the different region
should be provided. Default: FALSE.}

\item{ordered}{Logical indicating whether to sort output by significance
(adjusted p-value). Default: FALSE.}
}
\value{
There are several accessors to easily retrive information from a
\code{UMI4C-class} object:
\itemize{
  \item \code{dgram}: Returns a named list with the output domainograms for
  each sample.
  \item \code{bait}: Returns a \link[GenomicRanges]{GRanges-class} object with the position
   of the bait.
  \item \code{trend}: Returns a data.frame in long format with the values of
  the adapative smoothen trend.
  \item \code{resultsUMI4C}: Returns a \link[GenomicRanges]{GRanges-class} or data.frame with
  the results of the differential analysis.
}
}
\description{
This page contains a summary of the different methods used to
access the information contained inside the \code{UMI4C-class} object. See
the details section for more information on the different accessors.
}
\examples{
# Access the different information inside the UMI4C object
data("ex_ciita_umi4c")
ex_ciita_umi4c <- addGrouping(ex_ciita_umi4c, grouping="condition")

dgram(ex_ciita_umi4c)
bait(ex_ciita_umi4c)
head(trend(ex_ciita_umi4c))

# Perform differential test
enh <- GRanges(c("chr16:10925006-10928900", "chr16:11102721-11103700"))
umi_dif <- fisherUMI4C(ex_ciita_umi4c, query_regions = enh, 
                       filter_low = 20, resize = 5e3)
resultsUMI4C(umi_dif)
}
\seealso{
UMI4C, UMI4C-class
}
