% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{combineUMI4C}
\alias{combineUMI4C}
\title{Combine UMI4C fragments}
\usage{
combineUMI4C(umi4c, query_regions)
}
\arguments{
\item{umi4c}{UMI4C object as generated by \code{\link{makeUMI4C}} or the
\code{UMI4C} constructor.}

\item{query_regions}{\code{GRanges} object containing the coordinates of the 
genomic regions for combining restriction fragments.}
}
\value{
\code{UMI4C} object with rowRanges corresponding to query_regions and
assay containing the sum of raw UMI counts at each specified \code{query_region}.
}
\description{
Combine the UMI4C fragments that overlap a given set of \code{query_regions}.
}
\examples{
data("ex_ciita_umi4c")

wins <- makeWindowFragments(ex_ciita_umi4c)
umi_comb <- combineUMI4C(ex_ciita_umi4c, wins)
}
