% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_custom_vcf_from_uniquorn.R
\name{remove_library_from_database}
\alias{remove_library_from_database}
\title{Remove entire Library from Database}
\usage{
remove_library_from_database(library, ref_gen = "GRCH37", test_mode = FALSE)
}
\arguments{
\item{library}{a character vector giving the names of the library to be
removed.}

\item{ref_gen}{a character vector specifying the reference genome version.
All training sets are associated with a reference genome version. 
Default is \code{"GRCH37"}.}

\item{test_mode}{is this a test? Just for internal use.}
}
\value{
Message that indicates whether the removal was succesful.
}
\description{
This function removes a entire library from the database by removing all 
associated cancer cell line fingerprints from the database.
}
\examples{
remove_library_from_database(library = "CELLMINER",
                                ref_gen = "GRCH37",
                                test_mode = TRUE)
}
