% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/AllGenerics.R,
%   R/methods-SnpArrayExperiment.R
\docType{class}
\name{SnpArrayExperiment-class}
\alias{SnpArrayExperiment-class}
\alias{SnpArrayExperiment}
\alias{SnpArrayExperiment,missing-method}
\alias{SnpArrayExperiment,matrix-method}
\title{A RangedSummarizedExperiment-derived class of marker-level SNP array data
for copy number inference}
\usage{
SnpArrayExperiment(
  cn,
  baf,
  rowRanges = GRanges(),
  colData = DataFrame(),
  isSnp = logical(),
  ...
)

\S4method{SnpArrayExperiment}{missing}(
  cn,
  baf,
  rowRanges = GRanges(),
  colData = DataFrame(),
  isSnp = logical(),
  ...
)

\S4method{SnpArrayExperiment}{matrix}(
  cn,
  baf,
  rowRanges = GRanges(),
  colData = DataFrame(row.names = colnames(cn)),
  isSnp = logical(),
  ...
)
}
\arguments{
\item{cn}{matrix of copy number estimates (e.g., log R ratios)}

\item{baf}{matrix of B allele frequencies}

\item{rowRanges}{GRanges object for SNPs/nonpolymorphic markers}

\item{colData}{DataFrame containing sample-level covariates}

\item{isSnp}{logical vector indicating whether marker is a SNP}

\item{...}{additional arguments passed to \code{SummarizedExperiment()} constructor function}
}
\description{
Constructor for SnpArrayExperiment
}
\examples{
## empty container
library(VanillaICE)
data(snp_exp, package="VanillaICE") # example

se <- SnpArrayExperiment(cn=lrr(snp_exp), baf=baf(snp_exp),
                   rowRanges=rowRanges(snp_exp))
}
