% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-ArrayViews.R
\name{parseSourceFile}
\alias{parseSourceFile}
\alias{parseSourceFile,ArrayViews,CopyNumScanParams-method}
\title{Function for parsing GenomeStudio files}
\usage{
parseSourceFile(object, param)

\S4method{parseSourceFile}{ArrayViews,CopyNumScanParams}(object, param)
}
\arguments{
\item{object}{An \code{\linkS4class{ArrayViews}} object}

\item{param}{An object of class \code{\link{CopyNumScanParams}}}
}
\description{
This function parses genome studio files, writing the low-level
data for log R ratios, B allele frequencies, and genotypes to disk
as integers (1 file per subject per data type).
}
\examples{
  require(BSgenome.Hsapiens.UCSC.hg18)
  bsgenome <- BSgenome.Hsapiens.UCSC.hg18
  require(data.table)
  extdir <- system.file("extdata", package="VanillaICE", mustWork=TRUE)
  features <- suppressWarnings(fread(file.path(extdir, "SNP_info.csv")))
  fgr <- GRanges(paste0("chr", features$Chr), IRanges(features$Position, width=1),
                 isSnp=features[["Intensity Only"]]==0)
  fgr <- SnpGRanges(fgr)
  names(fgr) <- features[["Name"]]
  seqlevels(fgr) <- seqlevels(bsgenome)[seqlevels(bsgenome) \%in\% seqlevels(fgr)]
  seqinfo(fgr) <- seqinfo(bsgenome)[seqlevels(fgr),]
  fgr <- sort(fgr)
  files <- list.files(extdir, full.names=TRUE, recursive=TRUE, pattern="FinalReport")
  views <- ArrayViews(rowRanges=fgr, sourcePaths=files, parsedPath=tempdir())
  show(views)

## read the first file
dat <- fread(files[1], skip="[Data]")
## information to store on the markers
select <- match(c("SNP Name", "Allele1 - AB", "Allele2 - AB",
                  "Log R Ratio", "B Allele Freq"), names(dat))
##
## which rows to keep in the MAP file. By matching on the sorted GRanges object
## containing the feature annotation, the low-level data for the log R ratios/
## B allele frequencies will also be sorted
##
index_genome <- match(names(fgr), dat[["SNP Name"]])
scan_params <- CopyNumScanParams(index_genome=index_genome, select=select)
##
## parse the source files
##
parseSourceFile(views, scan_params)
list.files(parsedPath(views))
##
##  Inspecting source data through accessors defined on the views object
##
require(oligoClasses)
## log R ratios
r <- head(lrr(views))
## B allele frequencies
b <- head(baf(views))
g <- head(genotypes(views))
}
\seealso{
\code{\link{ArrayViews}} \code{\link{ArrayViews}} \code{\link{CopyNumScanParams}}
}
