% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TENxVisiumList-class.R
\docType{class}
\name{TENxVisiumList-class}
\alias{TENxVisiumList-class}
\alias{.TENxVisiumList}
\alias{TENxVisiumList}
\alias{import,TENxVisiumList,ANY,ANY-method}
\title{A class to represent and import multiple Visium samples}
\usage{
TENxVisiumList(
  sampleFolders,
  sample_ids,
  processing = c("filtered", "raw"),
  images = c("lowres", "hires", "detected", "aligned"),
  format = c("mtx", "h5"),
  jsonFile = .SCALE_JSON_FILE,
  tissuePattern = "tissue_positions.*\\\\.csv",
  spatialCoordsNames = c("pxl_col_in_fullres", "pxl_row_in_fullres"),
  ...
)

\S4method{import}{TENxVisiumList,ANY,ANY}(con, format, text, ...)
}
\arguments{
\item{sampleFolders}{\code{character()} A vector of strings specifying the
directories containing the output of the \verb{spaceranger count} command.}

\item{sample_ids}{\code{character()} A vector of strings specifying the sample
IDs. If not provided, the sample IDs will be the names of the
\code{sampleFolders}. Therefore, the \code{sample_ids} must be the same length
as \code{sampleFolders}.}

\item{processing}{\code{character(1)} A single string indicating the processing
folder available e.g., "filtered_feature_barcode_matrix" in the
\code{spacerangerOut} folder. It can be either "filtered" or "raw" (default
"filtered"). Only used when \code{spacerangerOut} is specified.}

\item{images}{\code{character()} A vector specifying the images to be imported;
can be one or multiple of "lowres", "hires", "detected", "aligned".}

\item{format}{The format of the output. If missing and \code{con} is a
file name, the format is derived from the file extension. This argument is
unnecessary when \code{con} is a derivative of \link[BiocIO:BiocFile-class]{BiocFile}.}

\item{jsonFile}{\code{character(1)} A single string specifying the name of the
JSON file containing the scale factors.}

\item{tissuePattern}{\code{character(1)} A single string specifying the pattern
to match the tissue positions file.}

\item{spatialCoordsNames}{\code{character()} A vector of strings specifying the
names of the columns in the spatial data containing the spatial coordinates.}

\item{...}{In the constructor, additional arguments passed to
\link[TENxIO:TENxFileList-class]{TENxFileList}; otherwise, not used.}

\item{con}{The connection from which data is loaded or to which data is
saved. If this is a \code{character} vector, it is assumed to be a file name and
a corresponding file connection is created and then closed after exporting
the object. If it is a \link[BiocIO:BiocFile-class]{BiocFile} derivative, the
data is loaded from or saved to the underlying resource. If missing, the
function will return the output as a character vector, rather than writing
to a connection.}

\item{text}{If \code{con} is missing, this can be a character vector directly
providing the string data to import.}
}
\value{
A \link[SpatialExperiment:SpatialExperiment]{SpatialExperiment}
object
}
\description{
This class contains a \code{SimpleList} of \link{TENxVisium} objects each
corresponding to one sample.
}
\details{
Typically, the user will provide a path to a directory containing
the output of the \verb{spaceranger count} command. The \verb{spaceranger count}
command outputs a folder containing the "raw" or "filtered"
\verb{()_feature_bc_matrix}.
}
\section{Functions}{
\itemize{
\item \code{import(con = TENxVisiumList, format = ANY, text = ANY)}: Import multiple Visium samples

}}
\examples{

sample_dirs <- list.dirs(
    system.file(
        file.path("extdata", "10xVisium"),
        package = "VisiumIO"
    ),
    recursive = FALSE, full.names = TRUE
)

tvl <- TENxVisiumList(
    sampleFolders = sample_dirs,
    sample_ids = c("sample01", "sample02"),
    processing = "raw",
    images = "lowres",
    format = "mtx"
)

import(tvl)

}
\seealso{
\url{https://support.10xgenomics.com/spatial-gene-expression/software/pipelines/latest/output/overview}
}
