% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate-downstream.R
\name{clusterVariograms}
\alias{clusterVariograms}
\title{Cluster variograms of multiple features}
\usage{
clusterVariograms(
  sfe,
  features,
  BLUSPARAM,
  n = 20,
  sample_id = "all",
  colGeometryName = NULL,
  annotGeometryName = NULL,
  reducedDimName = NULL,
  swap_rownames = NULL,
  name = "variogram"
)
}
\arguments{
\item{sfe}{A \code{SpatialFeatureExperiment} object with correlograms
computed for features of interest.}

\item{features}{Features whose correlograms to cluster.}

\item{BLUSPARAM}{A \linkS4class{BlusterParam} object specifying the algorithm to use.}

\item{n}{Number of points on the fitted variogram line.}

\item{sample_id}{Sample(s) in the SFE object whose cells/spots to use. Can be
"all" to compute metric for all samples; the metric is computed separately
for each sample.}

\item{colGeometryName}{Name of colGeometry from which to look for features.}

\item{annotGeometryName}{Name of annotGeometry from which to look for
features.}

\item{reducedDimName}{Name of a dimension reduction, can be seen in
\code{\link[SingleCellExperiment]{reducedDimNames}}. \code{colGeometryName} and
\code{annotGeometryName} have precedence over \code{reducedDimName}.}

\item{swap_rownames}{Column name of \code{rowData(object)} to be used to
identify features instead of \code{rownames(object)} when labeling plot
elements. If not found in \code{rowData}, then rownames of the gene count
matrix will be used.}

\item{name}{Name under which the correlogram results are stored, which is by
default "sp.correlogram".}
}
\value{
A data frame with 3 columns: \code{feature} for the features,
  \code{cluster} a factor for cluster membership of the features within each
  sample, and \code{sample_id} for the sample.
}
\description{
This function clusters variograms of features across samples to find patterns
in decays in spatial autocorrelation. The fitted variograms are clustered as
different samples can have different distance bins.
}
\examples{
library(SFEData)
library(scater)
library(bluster)
library(Matrix)
sfe <- McKellarMuscleData()
sfe <- logNormCounts(sfe)
# Just the highly expressed genes
gs <- order(Matrix::rowSums(counts(sfe)), decreasing = TRUE)[1:10]
genes <- rownames(sfe)[gs]

sfe <- runUnivariate(sfe, "variogram", features = genes)
clusts <- clusterVariograms(sfe, genes, BLUSPARAM = HclustParam(),
swap_rownames = "symbol")

# Plot the clustering
plotVariogram(sfe, genes, color_by = clusts, group = "feature",
use_lty = FALSE, swap_rownames = "symbol", show_np = FALSE)

}
\concept{Downstream analyses of univariate spatial results}
