% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-non-spatial.R
\name{plotColDataFreqpoly}
\alias{plotColDataFreqpoly}
\alias{plotRowDataFreqpoly}
\title{Plot frequency polygons for colData and rowData columns}
\usage{
plotColDataFreqpoly(
  sce,
  feature,
  color_by = NULL,
  subset = NULL,
  bins = 100,
  binwidth = NULL,
  linewidth = 1.2,
  scales = "free",
  ncol = 1,
  position = "identity"
)

plotRowDataFreqpoly(
  sce,
  feature,
  color_by = NULL,
  subset = NULL,
  bins = 100,
  binwidth = NULL,
  linewidth = 1.2,
  scales = "free",
  ncol = 1,
  position = "identity"
)
}
\arguments{
\item{sce}{A \code{SingleCellExperiment} object.}

\item{feature}{Names of columns in \code{colData} or \code{rowData} to plot.
When multiple features are specified, they will be plotted in separate
facets.}

\item{color_by}{Name of a categorical column in \code{colData} or
\code{rowData} to color the polygons.}

\item{subset}{Name of a logical column to only plot a subset of the data.}

\item{bins}{Number of bins. Overridden by \code{binwidth}. Defaults to 30.}

\item{binwidth}{The width of the bins. Can be specified as a numeric value
or as a function that takes x after scale transformation as input and
returns a single numeric value. When specifying a function along with a
grouping structure, the function will be called once per group.
The default is to use the number of bins in \code{bins},
covering the range of the data. You should always override
this value, exploring multiple widths to find the best to illustrate the
stories in your data.

The bin width of a date variable is the number of days in each time; the
bin width of a time variable is the number of seconds.}

\item{linewidth}{Line width of the polygons, defaults to a thicker 1.2.}

\item{scales}{Should scales be fixed (\code{"fixed"}, the default),
free (\code{"free"}), or free in one dimension (\code{"free_x"},
\code{"free_y"})?}

\item{ncol}{Number of columns in the facetting.}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}
}
\description{
This function is recommended instead of \code{\link{plotColDataHistogram}}
when coloring by multiple categories and log transforming the y axis, which
causes problems in stacked histograms.
}
\examples{
library(SFEData)
sfe <- McKellarMuscleData()
plotColDataFreqpoly(sfe, c("nCounts", "nGenes"), color_by = "in_tissue",
                    bins = 50)
plotColDataFreqpoly(sfe, "nCounts", subset = "in_tissue")
sfe2 <- sfe[, sfe$in_tissue]
plotColDataFreqpoly(sfe2, c("nCounts", "nGenes"), bins = 50)
}
\seealso{
plotColDataHistogram
}
