% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fragsize.R
\name{getFragmentsDistribution}
\alias{getFragmentsDistribution}
\title{A function to compute sizes distribution for paired-end fragments}
\usage{
getFragmentsDistribution(
  fragments,
  granges_list = NULL,
  extend_granges = c(-500, 500),
  limits = c(0, 600),
  roll = 3,
  cores = 1
)
}
\arguments{
\item{fragments}{GRanges object containing paired-end fragments.
See importPEBamFiles for more details on how to create such object.}

\item{granges_list}{GRanges, can be a list of different sets of GRanges.}

\item{extend_granges}{numeric vector of length 2, how the GRanges 
should be extended.}

\item{limits}{numeric vector of length 2, only consider 
fragments within this window of sizes.}

\item{roll}{Integer, apply a moving average of this size}

\item{cores}{Integer, number of threads used to compute 
fragment size distribution}
}
\value{
A list of tbl, one for each .bam file.
}
\description{
This function takes fragments and compute the distribution of their
sizes over a set or multiple sets of GRanges.
}
\examples{
data(bam_test)
data(ce11_proms)
df <- getFragmentsDistribution(
    bam_test, 
    ce11_proms,
    extend_granges = c(-500, 500)
)
head(df)
which.max(df$y)
}
