% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_functions.R
\name{split_exposures_by_subgroups}
\alias{split_exposures_by_subgroups}
\title{Split an exposures data frame by subgroups}
\usage{
split_exposures_by_subgroups(
  in_exposures_df,
  in_subgroups_df,
  in_subgroups.field = "subgroup",
  in_PID.field = "PID"
)
}
\arguments{
\item{in_exposures_df}{Numerical data frame of the exposures (i.e.
contributions of the different signatures to the number of point mutations
per PID)}

\item{in_subgroups_df}{Data frame indicating which PID belongs to which
subgroup}

\item{in_subgroups.field}{Name indicating which column in
\code{in_subgroups_df} contains the subgroup information}

\item{in_PID.field}{Name indicating which column in \code{in_subgroups_df}
contains the PID information}
}
\value{
List of data frames with the subgroup specific signature exposures.
}
\description{
If a cohort consists of different subgroups, this function enables to split
the data frame storing the signature exposures into a list of data frames
with signature exposures, one per subgroup. This functionality is needed for
\code{\link{stat_test_subgroups}} and \code{\link{stat_plot_subgroups}}
}
\examples{
 NULL

}
\seealso{
\code{\link{stat_test_subgroups}}

\code{\link{stat_plot_subgroups}}
}
