% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/digestMod.R
\name{digestMod}
\alias{digestMod}
\title{modified \code{\link[OrgMassSpecR]{Digest}} function 
(from OrgMassSpecR package)}
\usage{
digestMod(sequence, enzyme = "trypsin", missed = 0, 
maxCharge = 8,IAA = TRUE, N15 = FALSE, custom = list())
}
\arguments{
\item{sequence}{a character string representing the amino acid sequence.}

\item{enzyme}{is the enzyme to perform in silico digestion with}

\item{missed}{the maximum number of missed cleavages. 
Must be an integer of 0 (default)
or greater. An error will result if the specified number of 
missed cleavages is
greater than the maximum possible number of missed cleavages.}

\item{maxCharge}{numeric max charge charge for predicted precursor m/z}

\item{IAA}{logical. TRUE specifies iodoacetylated cysteine and FALSE 
specifies unmodified
cysteine. Used only in determining the elemental formula, 
not the three letter codes.}

\item{N15}{logical indicating if the nitrogen-15 isotope should be used
in place of the default
nitrogen-14 isotope.
calculation}

\item{custom}{list of custom masses}
}
\value{
dataframe
}
\description{
allows maxCharge to be set to calculate precursor m/z
}
\details{
see \code{\link{Digest}} for details of further function arguments.
}
\examples{
digestMod('MKWVTFISLLFLFSSAYSRGVFRRDAHKSEVAHRFKDLGEENFKALVLIA',
enzyme = "trypsin", missed = 0, maxCharge = 8,IAA = TRUE, N15 = FALSE, 
custom = list()) 
}
