% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peakListId.R
\name{peakListId}
\alias{peakListId}
\title{peak list Identification}
\usage{
peakListId(adductSpectra = NULL, peakList = c(290.21, 403.3, 
516.38, 587.42, 849.4, 884.92, 958.46, 993.97, 1050.52, 1107.06,
1209.73, 1337.79,
1465.85), exPeakMass = 834.7769, frag.delta = 1, minPeaksId = 7, 
minSpecEx = 50, maxRtDrift = 360, maxPpmDev = 200, allScans = TRUE, 
closestMassByFile = TRUE, outputPlotDir = NULL)
}
\arguments{
\item{adductSpectra}{AdductSpec object
param peakList numeric vector of peak masses
param exPeakMass numeric internal standard peak mass}

\item{peakList}{numeric vector of peak masses}

\item{exPeakMass}{numeric mass of explained peak}

\item{frag.delta}{integer delta mass accuracy difference.}

\item{minPeaksId}{numeric minimum number of peaks IDed}

\item{minSpecEx}{numeric the minimum percentage of the total ion 
current explained
by the internal standard fragments (default = 40). Sometime spectra are not
identified due to this cutoff being set too high. If unexpected datapoints
have been interpolated then reduce this value.}

\item{maxRtDrift}{numeric the maximum retention time drift (in seconds)
to identify MS/MS spectrum scans (default = 360).
param outputPlotDir character string of output directory
(e.g. internal standard IAA-T3 peak list = peakList= c(290.21, 403.30, 
516.38, 587.42, 849.40, 884.92, 958.46, 993.97, 1050.52, 1107.06, 1209.73, 
1337.79, 1465.85))}

\item{maxPpmDev}{numeric ppm deviation}

\item{allScans}{boolean include all scans}

\item{closestMassByFile}{boolean closest mass in files}

\item{outputPlotDir}{character string for output plot directory}
}
\value{
dataframe peak list
}
\description{
peak list Identification
}
