% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retentionCorr.R
\name{retentionCorr}
\alias{retentionCorr}
\title{loess-based retention time deviation correction}
\usage{
retentionCorr(adductSpectra = NULL, 
smoothingSpan = NULL, nMissing = 1, 
nExtra = 1, folds = 7, outputFileDir = NULL)
}
\arguments{
\item{adductSpectra}{AdductSpec object}

\item{smoothingSpan}{numeric. fixed smoothing span, argument to loess.
If argument is not supplied then optimal smoothing span is 
calculated for each file seperately.}

\item{nMissing}{numeric. maximum number of missing files for a 
MS/MS scan group to be
utilized in the loess retention time deviation model. 
Roughly 15 percent missing values is a good starting point 
(e.g. nMissing=10 for 68 samples).}

\item{nExtra}{numeric maximum number of extra scans above
the total number of
files for a MS/MS scan group to be utilized in the 
loess retention time deviation model.
If a MS/MS scan group consists of many scans far 
in excess of the number of files
then potentially MS/MS scans from large tailing peaks or
isobars may be erroneously
grouped together and used to adjust retention time incorrectly.}

\item{folds}{numeric. number of cross validation steps to 
perform in identifying
optimal smoothing span parameter (see: bisoreg package
for more details)}

\item{outputFileDir}{character full path to a directory 
to save the output images}
}
\value{
LOESS RT models as adductSpectra AdductSpec object
}
\description{
loess-based retention time deviation correction
}
