% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloneDirectory.R
\name{cloneDirectory}
\alias{cloneDirectory}
\title{Clone an existing directory}
\usage{
cloneDirectory(src, dest, action = c("link", "copy", "symlink", "relsymlink"))
}
\arguments{
\item{src}{String containing the path to the source directory, typically generated by a prior \code{\link{saveObject}} call.}

\item{dest}{String containing the path to the destination directory, typically the \code{path} in a subsequent \code{\link{saveObject}} call..}

\item{action}{String specifying the action to use when cloning files from \code{src} to \code{dest}.
\itemize{
\item \code{"copy"}: copy the files from \code{src} to \code{dest}.
\item \code{"link"}: create a hard link from the files in \code{src} to their new locations in \code{dest}.
If this fails, we silently fall back to a copy.
This mode is the default approach.
\item \code{"symlink"}: create a symbolic link from the files in \code{src} to their new locations in \code{dest}.
Each symbolic link refers to an absolute path in the original directory, which is useful when the contents of \code{dest} might be moved (but the original directory will not).
\item \code{"relsymlink"}: create a symbolic link from the files in \code{src} to their new locations in \code{dest}.
Each symbolic link refers to an relative path to its corresponding file in the original directory,
which is useful when both \code{src} and \code{dest} are moved together, e.g., as they are part of the same parent object like a SummarizedExperiment.
}}
}
\value{
A new directory is created at \code{dest} with the contents of \code{src}, either copied or linked.
\code{NULL} is invisibly returned.
}
\description{
Clone an existing directory to a new location.
This is typically performed inside \code{\link{saveObject}} after detecting duplicated objects, see \code{?\link{createDedupSession}} for details.
}
\examples{
tmp <- tempfile()
dir.create(tmp)

src <- file.path(tmp, "A")
dir.create(src)
write(file=file.path(src, "foobar"), LETTERS)

dest <- file.path(tmp, "B")
cloneDirectory(src, dest)
list.files(dest, recursive=TRUE)

}
\author{
Aaron Lun
}
