% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useBumpyHDF5.R
\name{useBumpyHDF5}
\alias{useBumpyHDF5}
\title{Save BumpyMatrix data to HDF5}
\usage{
useBumpyHDF5(use)
}
\arguments{
\item{use}{Logical scalar indicating whether to save in HDF5.}
}
\value{
If \code{use} is missing, a logical scalar is returned indicating whether data should be saved in HDF5.

If \code{use} is provided, it is used to set the corresponding flag globally.
The previous value of the flag is returned invisibly.
}
\description{
Use HDF5 for the underlying data frame, i.e., obtained after \code{\link{unlist}}ing the \linkS4class{BumpyMatrix}.
This is less intuitive than a CSV but preserves the precision of floating-point numbers.
}
\examples{
useBumpyHDF5()

old <- useBumpyHDF5(FALSE)
useBumpyHDF5()

# Setting it back.
useBumpyHDF5(old)
}
