% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FastaFileReference.R
\docType{class}
\name{FastaFileReference}
\alias{FastaFileReference}
\alias{FastaFileReference-class}
\alias{saveObject,FastaFileReference-method}
\alias{readFastaFileReference}
\alias{FastaWrapper}
\alias{FastaWrapper-class}
\alias{stageObject,FastaWrapper-method}
\alias{show,FastaWrapper-method}
\alias{loadFastaWrapper}
\alias{FaIndexWrapper}
\alias{FaIndexWrapper-class}
\alias{stageObject,FaIndexWrapper-method}
\alias{loadFaIndexWrapper}
\title{Reference to a FASTA file}
\usage{
FastaFileReference(path, seqtype = "DNA", faindex = NULL, gzindex = NULL)
}
\arguments{
\item{path}{String containing the path to a Gzip- or BGZF-compressed FASTA file.}

\item{seqtype}{String specifying the sequence type.
This should be one of \code{"DNA"}, \code{"RNA"}, \code{"AA"} or \code{"custom"}.}

\item{faindex}{String specifying the path to an FASTA index file, or \code{NULL} if no index is available.
If an index is supplied, the file at \code{path} should be BGZF-compressed, and \code{gzindex} should also be supplied.}

\item{gzindex}{String specifying the path to a BGZF index file, or \code{NULL} if no index is available.
If an index is supplied, the file at \code{path} should be BGZF-compressed, and \code{faindex} should also be supplied.}
}
\value{
A FastaFileReference instance that can be used in \code{\link{saveObject}}.
}
\description{
Reference to a FASTA file, for saving and loading in the \pkg{alabaster} framework.
}
\examples{
# Mocking up a FASTA file.
tmp <- tempfile(fileext=".fa.gz")
write(">FOOBAR\nacgtacgt", gzfile(tmp))

# Creating a FastaFileReference.
wrapped <- FastaFileReference(tmp)
wrapped

# Saving to disk:
dir <- tempfile()
saveObject(wrapped, dir)
list.files(dir, recursive=TRUE)

# Loading it back again:
readObject(dir)

}
\author{
Aaron Lun
}
