% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveAtomicVectorList.R
\name{saveObject,CompressedAtomicList-method}
\alias{saveObject,CompressedAtomicList-method}
\alias{stageObject,CompressedAtomicList-method}
\title{Save compressed list of atomic vectors to disk}
\usage{
\S4method{saveObject}{CompressedAtomicList}(x, path, ...)
}
\arguments{
\item{x}{A \linkS4class{CompressedAtomicList} object.}

\item{path}{String containing the path to a directory in which to save \code{x}.}

\item{...}{Further arguments to pass to specific methods.}
}
\value{
\code{x} is saved to \code{path}, and \code{NULL} is invisibly returned.
}
\description{
Save a \linkS4class{CompressedAtomicList} object to its on-disk representation.
}
\examples{
library(S4Vectors)
X <- splitAsList(LETTERS, sample(3, 26, replace=TRUE))

tmp <- tempfile()
saveObject(X, tmp)
list.files(tmp, recursive=TRUE)

}
\seealso{
\code{\link{readAtomicVectorList}}, to read a \linkS4class{CompressedAtomicList} from disk.
}
\author{
Aaron Lun
}
