% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readXStringSet.R
\name{readXStringSet}
\alias{readXStringSet}
\alias{loadXStringSet}
\title{Read an XStringSet from disk.}
\usage{
readXStringSet(path, metadata, ...)
}
\arguments{
\item{path}{String containing a path to a directory, itself created using the \code{\link{saveObject}} method for \linkS4class{XStringSet} objects.}

\item{metadata}{Named list of metadata for this object, see \code{\link{readObjectFile}} for details.}

\item{...}{Further arguments passed to internal \code{\link{altReadObject}} calls.}
}
\value{
An \linkS4class{XStringSet} subclass containing DNA, RNA, protein or custom sequences.
This may also be a \linkS4class{QualityScaledDNAStringSet} with quality scores.
}
\description{
Read a \linkS4class{XStringSet} object from its on-disk representation.
This is usually not directly called by users, but is instead called by dispatch in \code{\link{readObject}}.
}
\examples{
library(Biostrings)
stuff <- DNAStringSet(c("AAA", "CC", "G", "TTTT"))

tmp <- tempfile()
saveObject(stuff, tmp)
readObject(tmp)

}
\seealso{
\code{"\link{saveObject,XStringSet-method}"}, to save an \linkS4class{XStringSet} to disk.
}
