% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anansi-package.R, R/anansi.R
\docType{package}
\name{anansi}
\alias{anansi}
\alias{anansi-package}
\title{anansi: Annotation-based Analysis of Specific Interactions.}
\usage{
anansi(
  web,
  formula,
  groups = NULL,
  metadata = NULL,
  adjust.method = "BH",
  verbose = TRUE,
  return.format = "table",
  ...
)
}
\arguments{
\item{web}{An \code{AnansiWeb} object, containing two tables with 'omics data
and a dictionary that links them. See \code{weaveWebFromTables()} for how to
weave a web.}

\item{formula}{A formula object. Used to assess differential associations.}

\item{groups}{A vector of the column names of categorical values in the
metadata object to control which groups should be assessed for simple
correlations.
If no argument provided, anansi will let you know and still to regular
correlations according to your dictionary.}

\item{metadata}{A vector or data.frame of categorical or continuous value
necessary for differential correlations. Typically a state or treatment.
If no argument provided, anansi will let you know and still to regular
correlations according to your dictionary.}

\item{adjust.method}{Method to adjust p-values for multiple comparisons.
\code{adjust.method = "BH"} is the default value. See \code{p.adjust()} in
the base R \code{stats} package.}

\item{verbose}{\verb{Logical scalar}. Whether to print diagnostic information
(Default: \code{TRUE}).
while running. Useful for debugging errors on large datasets.}

\item{return.format}{\verb{Character scalar}. Should be one of \code{"table"},
\code{"list"}, or \code{"raw"}. Should the output of \code{\link[=anansi]{anansi()}}
respectively be a wide \code{data.frame} of results, a list containing the results
and input, or a list of raw output (used for testing purposes).
convenient use. (Default: \code{"table"})}

\item{...}{additional arguments (currently not used).}
}
\value{
A list of lists containing correlation coefficients, p-values and
q-values for all operations.
}
\description{
The anansi package package provides tools to prepare and facilitate
integrative association analysis between the features of two data sets that
are known to interact.
\subsection{1. Input for \code{anansi()} with \code{\link[=AnansiWeb]{AnansiWeb()}} and \code{\link[=MultiFactor]{MultiFactor()}}}{

\itemize{
\item \link{randomAnansi}, \code{\link[=kegg_link]{kegg_link()}}: Generate example input
\item \link{AnansiWeb}, \link{MultiFactor}: Handle and manipulate
input
}
}

\subsection{2. Output and cross-compatibility}{

\itemize{
\item \code{\link[=getGraph]{getGraph()}}: Compatibility with \link[igraph:aaa-igraph-package]{igraph::igraph}
\item \code{\link[=plotAnansi]{plotAnansi()}}: Plot output in the style of \link[miaViz:miaViz-package]{miaViz::miaViz}
}
}

\subsection{3. Vignettes}{

\itemize{
\item
\href{https://thomazbastiaanssen.github.io/anansi/articles/anansi.html}{1. Getting started with anansi}
\item
\href{https://thomazbastiaanssen.github.io/anansi/articles/adjacency_matrices.html}{2. Adjacency matrices}
\item
\href{https://thomazbastiaanssen.github.io/anansi/articles/association_testing.html}{3. Association testing}
}
}

\subsection{Description: The \code{anansi()} function}{

The main workspider function in the anansi package is called
\code{anansi}. It manages the individual functionalities of anansi, including
correlation analysis, correlation by group and differential associations.
}
}
\examples{
# Load example data:

data(FMT_data)

# Make sure that columns are features and rows are samples.

t1 <- t(FMT_metab)
t2 <- t(FMT_KOs)

# Run anansi pipeline.

web <- weaveWeb(
    cpd ~ ko,
    tableY = t1,
    tableX = t2,
    link = kegg_link()
)

anansi_out <- anansi(
    web = web,
    formula = ~Legend,
    groups = "Legend",
    metadata = FMT_metadata,
    adjust.method = "BH",
    verbose = TRUE
)


library(tidyr)

# Use tidyr to wrangle the correlation r-values to a single column
anansiLong <- anansi_out |>
    pivot_longer(starts_with("All") | contains("FMT")) |>
    separate_wider_delim(
        name,
        delim = "_", names = c("cor_group", "param")
    ) |>
    pivot_wider(names_from = param, values_from = value)

# Only consider interactions where the entire model fits well enough.
library(ggplot2)
anansiLong <- anansiLong[anansiLong$full_p.values < 0.05, ]



ggplot(
    data = anansiLong,
    aes(
        x = r.values,
        y = feature_X,
        fill = cor_group,
        alpha = disjointed_Legend_p.values < 0.05
    )
) +

    # Make a vertical dashed red line at x = 0
    geom_vline(xintercept = 0, linetype = "dashed", colour = "red") +

    # Points show  raw correlation coefficients
    geom_point(shape = 21, size = 3) +

    # facet per compound
    ggforce::facet_col(~feature_Y, space = "free", scales = "free_y") +
    scale_fill_manual(values = c(
        "Young yFMT" = "#2166ac",
        "Aged oFMT" = "#b2182b",
        "Aged yFMT" = "#ef8a62",
        "All" = "gray"
    )) +
    theme_bw()

# Using miaViz style function:

p <- plotAnansi(anansi_out,
    association.type = "disjointed",
    model.var = "Legend",
    fill_by = "group",
    signif.threshold = 0.05,
    x_lab = "Pearson's rho"
)
p <- p +
    scale_fill_manual(values = c(
        "Young yFMT" = "#2166ac",
        "Aged oFMT" = "#b2182b",
        "Aged yFMT" = "#ef8a62",
        "All" = "gray"
    )) +
    theme_bw()

p

}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/thomazbastiaanssen/anansi}
  \item \url{https://thomazbastiaanssen.github.io/anansi}
  \item Report bugs at \url{https://github.com/thomazbastiaanssen/anansi/issues}
}

}
\author{
\strong{Maintainer}: Thomaz Bastiaanssen \email{thomazbastiaanssen@gmail.com} (\href{https://orcid.org/0000-0001-6891-734X}{ORCID})

Authors:
\itemize{
  \item Thomas Quinn \email{contacttomquinn@gmail.com} (\href{https://orcid.org/0000-0003-0286-6329}{ORCID})
  \item Giulio Benedetti \email{giulio.benedetti@utu.fi} (\href{https://orcid.org/0000-0002-8732-7692}{ORCID})
  \item Tuomas Borman \email{tuomas.v.borman@utu.fi} (\href{https://orcid.org/0000-0002-8563-8884}{ORCID})
  \item Leo Lahti \email{leo.lahti@utu.fi} (\href{https://orcid.org/0000-0001-5537-637X}{ORCID})
}

}
\keyword{internal}
