% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnnData-usage.R
\name{AnnData-usage}
\alias{AnnData-usage}
\title{AnnData structure and usage}
\value{
An \code{AnnData} object inheriting from \code{\link{AbstractAnnData}}
}
\description{
The \code{AnnData} object stores a data matrix \code{X} together with annotations of
observations \code{obs} (\code{obsm}, \code{obsp}) and variables \code{var} (\code{varm}, \code{varp}).
Additional layers of data can be stored in \code{layers} and unstructured
annotations in \code{uns}.
\subsection{Back ends}{

There are different back ends for \code{AnnData} objects that inherit from the
abstract \link{AbstractAnnData} class and store and access data in different ways:
\itemize{
\item \link{InMemoryAnnData} stores data in memory
\item \link{HDF5AnnData} provides an interface to a H5AD file
\item \link{ReticulateAnnData} wraps a Python \code{AnnData} object via \pkg{reticulate}
}

See the class documentation for details.
}

\subsection{Usage}{

The items listed as \strong{"Slots"} are elements of the \code{AnnData} object that
contain data and can be accessed or set. \strong{"Fields"} return information
about the \code{AnnData} object but cannot be set directly. Both, as well as
methods, can be accessed using the \code{$} operator

For example:
\itemize{
\item \code{adata$X} returns the \code{X} matrix
\item \code{adata$X <- x} sets the \code{X} matrix
\item \code{adata$method()} calls a method
}
}
}
\section{Fields}{

\describe{
\item{\code{shape}}{Dimensions (observations x variables) of the \code{AnnData} object}

\item{\code{n_obs}}{Number of observations}

\item{\code{n_vars}}{Number of variables}

\item{\code{obs_keys}}{Keys (column names) of \code{obs}}

\item{\code{var_keys}}{Keys (column names) of \code{var}}

\item{\code{layers_keys}}{Keys (element names) of \code{layers}}

\item{\code{obsm_keys}}{Keys (element names) of \code{obsm}}

\item{\code{varm_keys}}{Keys (element names) of \code{varm}}

\item{\code{obsp_keys}}{Keys (element names) of \code{obsp}}

\item{\code{varp_keys}}{Keys (element names) of \code{varp}}

\item{\code{uns_keys}}{Keys (element names) of \code{uns}}
}}

\section{Slots}{

\describe{
\item{\code{X}}{The main data matrix. Either \code{NULL} or an observation x variable
matrix (without dimnames) with dimensions consistent with \code{n_obs} and
\code{n_vars}.}

\item{\code{layers}}{Additional data layers. Must be \code{NULL} or a named list of
matrices having dimensions consistent with \code{n_obs} and \code{n_vars}.}

\item{\code{obs}}{Observation annotations. A \code{data.frame} with columns containing
information about observations. The number of rows of \code{obs} defines the
observation dimension of the \code{AnnData} object (\code{n_obs}). If \code{NULL}, an
\code{n_obs} × 0 \code{data.frame} will automatically be generated.}

\item{\code{var}}{Variable annotations. A \code{data.frame} with columns containing
information about variables. The number of rows of \code{var} defines the
variable dimension of the \code{AnnData} object (\code{n_vars}). If \code{NULL}, an
\code{n_vars} × 0 \code{data.frame} will automatically be generated.}

\item{\code{obs_names}}{Observation names. Either \code{NULL} or a vector of unique
identifiers used to identify each row of \code{obs} and to act as an index into
the observation dimension of the \code{AnnData} object. For compatibility with
\emph{R} representations, \code{obs_names} should be a unique character vector.}

\item{\code{var_names}}{Variable names. Either \code{NULL} or a vector of unique
identifiers used to identify each row of \code{var} and to act as an index into
the variable dimension of the \code{AnnData} object. For compatibility with \emph{R}
representations, \code{var_names} should be a unique character vector.}

\item{\code{obsm}}{Multi-dimensional observation annotation. Must be \code{NULL} or a
named list of array-like elements with number of rows equal to \code{n_obs}.}

\item{\code{varm}}{Multi-dimensional variable annotations. Must be \code{NULL} or a named
list of array-like elements with number of rows equal to \code{n_vars}.}

\item{\code{obsp}}{Observation pairs. Must be \code{NULL} or a named list of array-like
elements with number of rows and columns equal to \code{n_obs}.}

\item{\code{varp}}{Variable pairs. Must be \code{NULL} or a named list of array-like
elements with number of rows and columns equal to \code{n_vars}.}

\item{\code{uns}}{Unstructured annotations. Must be \code{NULL} or a named list.}
}}

\section{Methods}{

\subsection{Conversion methods:}{

\describe{
\item{
\code{as_SingleCellExperiment()}
}{
Convert to \code{\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment::SingleCellExperiment}}, see
\code{\link[=as_SingleCellExperiment]{as_SingleCellExperiment()}}
}
\item{\code{as_Seurat()}}{Convert to \code{\link[SeuratObject:Seurat-class]{SeuratObject::Seurat}}, see \code{\link[=as_Seurat]{as_Seurat()}}}
\item{\code{as_InMemoryAnnData()}}{Convert to \code{\link{InMemoryAnnData}}, as \code{\link[=as_InMemoryAnnData]{as_InMemoryAnnData()}}}
\item{\code{as_HDF5AnnData()}}{Convert to \code{\link{HDF5AnnData}}, see \code{\link[=as_HDF5AnnData]{as_HDF5AnnData()}}}
\item{\code{as_ReticulateAnnData()}}{Convert to \code{\link{ReticulateAnnData}}, see \code{\link[=as_ReticulateAnnData]{as_ReticulateAnnData()}}}
}
}

\subsection{Output methods:}{

\describe{
\item{
\code{write_h5ad()}
}{
Write the \code{AnnData} object to an HDF5 file, see \code{\link[=write_h5ad]{write_h5ad()}}
}
}
}

\subsection{General methods:}{

\describe{
\item{\code{print()}}{Print a summary of the \code{AnnData} object}
}
}
}

\section{Functions that can be used to create AnnData objects}{


\describe{
\item{\code{\link[=AnnData]{AnnData()}}}{Create an \link{InMemoryAnnData} object}
\item{\code{\link[=read_h5ad]{read_h5ad()}}}{Read an \code{AnnData} from a H5AD file}
\item{\code{\link[=as_AnnData]{as_AnnData()}}}{Convert other objects to an \code{AnnData} object}
}
}

\seealso{
The documentation for the Python \code{anndata} package
\url{https://anndata.readthedocs.io/en/stable/}

\link{AbstractAnnData} for the abstract class that all \code{AnnData} objects
inherit from

\link{InMemoryAnnData} for the in-memory implementation of \code{AnnData}

\link{HDF5AnnData} for the HDF5-backed implementation of \code{AnnData}

\link{ReticulateAnnData} for the reticulate-based implementation that wraps Python AnnData objects
}
