% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annoLinkerResult.R
\docType{class}
\name{annoLinkerResult-class}
\alias{annoLinkerResult-class}
\alias{annoLinkerResult}
\alias{coerce}
\alias{coerce,annoLinkerResult,GRanges-method}
\alias{as.data.frame,annoLinkerResult-method}
\alias{anno_peaks}
\alias{anno_peaks,annoLinkerResult-method}
\alias{anno_graph}
\alias{anno_graph,annoLinkerResult-method}
\alias{anno_clusters}
\alias{anno_clusters,annoLinkerResult-method}
\alias{anno_evidence}
\alias{anno_evidence,annoLinkerResult-method}
\alias{anno_evidence,annoLinkerResult,numeric-method}
\alias{anno_event}
\alias{anno_event,annoLinkerResult-method}
\alias{anno_event,annoLinkerResult,numeric-method}
\alias{anno_feature}
\alias{anno_feature,annoLinkerResult-method}
\alias{anno_feature,annoLinkerResult,numeric-method}
\alias{anno_peakbin}
\alias{anno_peakbin,annoLinkerResult-method}
\alias{anno_peakbin,annoLinkerResult,numeric-method}
\alias{anno_featurebin}
\alias{anno_featurebin,annoLinkerResult-method}
\alias{anno_featurebin,annoLinkerResult,numeric-method}
\alias{length,annoLinkerResult-method}
\alias{show,annoLinkerResult-method}
\alias{head,annoLinkerResult-method}
\alias{head,annoLinkerResult,ANY-method}
\title{Class \code{"annoLinkerResult"}}
\usage{
\S4method{as.data.frame}{annoLinkerResult}(x, row.names = NULL, optional = FALSE, ...)

anno_peaks(x)

\S4method{anno_peaks}{annoLinkerResult}(x)

anno_graph(x)

\S4method{anno_graph}{annoLinkerResult}(x)

anno_clusters(x)

\S4method{anno_clusters}{annoLinkerResult}(x)

anno_evidence(x, i)

\S4method{anno_evidence}{annoLinkerResult}(x, i)

anno_event(x, i)

\S4method{anno_event}{annoLinkerResult}(x, i)

anno_feature(x, i)

\S4method{anno_feature}{annoLinkerResult}(x, i)

anno_peakbin(x, i)

\S4method{anno_peakbin}{annoLinkerResult}(x, i)

anno_featurebin(x, i)

\S4method{anno_featurebin}{annoLinkerResult}(x, i)

\S4method{length}{annoLinkerResult}(x)

\S4method{show}{annoLinkerResult}(object)

\S4method{head}{annoLinkerResult}(x, ...)
}
\arguments{
\item{x, object}{An annoLinkerResult object.}

\item{row.names, optional, ...}{parameters used by \link[base]{as.data.frame}}

\item{i}{Numeric, index value.}
}
\value{
The object of 'annoLinkerResult', 'GRanges', 'igraph' or 'data.frame'
}
\description{
An object of class \code{"annoLinkerResult"} represent the annotated peaks,
which is a GRanges object with peaks annotated by gene clusters, and
interaction graph, which is an igraph graph.
}
\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new("annoLinkerResult", annotated_peaks, graph, clusters)}.
}

\examples{
library(igraph)
library(GenomicRanges)
new("annoLinkerResult",
    annotated_peaks = GRanges(),
    graph = make_empty_graph(),
    clusters = data.frame()
)
}
\keyword{classes}
