% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEvidence.R
\name{plotEvidence}
\alias{plotEvidence}
\title{Plot interaction network for visualization}
\usage{
plotEvidence(
  anno,
  event,
  output = c("graph", "htmlWidget", "trackPlot"),
  colors = c(peak = "darkgreen", feature = "brown", node = "tomato", background =
    "lightgray"),
  txdb,
  org
)
}
\arguments{
\item{anno}{An object of annoLinkerResult output by \link{annoLinker}}

\item{event}{Number to indicate the event to be plot}

\item{output}{Output of the plot.}

\item{colors}{Colors setting for the plot.}

\item{txdb, org}{The TxDb and OrgDb object used for annotation plot.}
}
\value{
htmlWidget or plots.
}
\description{
Plot interaction network for visualization
}
\examples{
anno <- readRDS(system.file("extdata", "sample_res.rds",
    package = "annoLinker"
))
library(org.Dr.eg.db)
library(TxDb.Drerio.UCSC.danRer10.refGene)
n <- 1 # length(anno$annotated_peaks$evidences)
plotEvidence(anno,
    event = n,
    output = "htmlWidget"
)
plotEvidence(anno,
    event = n,
    output = "trackPlot"
)
}
