% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_annotations.R
\docType{data}
\name{annotatr_cache}
\alias{annotatr_cache}
\title{A global-variable to hold custom annotations loaded in an R session}
\format{
An object of class \code{list} of length 3.
}
\usage{
annotatr_cache
}
\value{
An environment to contain custom annotations from \code{read_annotations}.
}
\description{
Code thanks to Martin Morgan. This is a global variable that will store custom
annotations that a user reads in during a session in which annotatr is loaded.
}
\examples{
 # Example usage
 annotatr_cache$set("foo", 1:10)
 annotatr_cache$get("foo")

 # Read in a BED3 file as a custom annotation
 file = system.file('extdata', 'test_annotations_3.bed', package='annotatr')
 # The custom annotation is added to the annotatr_cache environment in this function
 read_annotations(con = file, name = 'test', genome = 'hg19')
 # The result of read_annotations() is not visible in .GlobalEnv, instead
 # need to use the get method
 print(annotatr_cache$get('hg19_custom_test'))
 # See what is in the annotatr_cache
 annotatr_cache$list_env()
}
\keyword{datasets}
