% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prefilterSAM.R
\name{prefilterSAM}
\alias{prefilterSAM}
\title{Pre-filter Genes using SAM (Significance Analysis of Microarrays)}
\usage{
prefilterSAM(
  seData,
  groupsVector,
  FDRfilter = 0.05,
  iter = 100,
  percentageFilter = 80,
  verbose = TRUE
)
}
\arguments{
\item{seData}{SummarizedExperiment object with the normalized expression 
data and the phenotypic data in colData.}

\item{groupsVector}{A binary vector indicating group assignment the samples.}

\item{FDRfilter}{A numeric value indicating the FDR threshold for selecting 
significant genes. Default is 0.05.}

\item{iter}{The number of iterations for bootstrapping. Default is 100.}

\item{percentageFilter}{A numeric value indicating the percentage of 
iterations a gene must appear in to be considered significant. Default is 80.}

\item{verbose}{Logical. Show progress bar.}
}
\value{
An ordered vector with the names of differentially expressed genes 
between the categories of the grouping vector. A list of DE genes ordered 
by SAM d.value and filtered by percentageFilter.
}
\description{
This function performs pre-filtering of genes based on Significance Analysis 
of Microarrays (SAM). It runs a bootstrapping procedure to select 
significant genes based on the False Discovery Rate (FDR) and allows 
filtering by the percentage of times a gene is selected across multiple 
iterations.
}
\details{
This function implements SAM (Schwender H., 2022) robust diferential 
expression analysis based on bootstrap . It helps to remove noisy genes 
reducing the computational complexity of further analysis. The function 
uses a bootstrapping approach, where in each iteration a random sample is 
drawn from the input data (with replacement), and the SAM algorithm is 
applied to select significant genes. The genes that appear as significant 
in a specified percentage of iterations (controlled by `percentageFilter`) 
are retained.
}
\examples{
data(seBRCA)

# Bootstrapped differential expression based on SAM.
# Parameters: FDR = 0.05, iter = 100, percentage filter = 80 \%
# CAUTION: if the data have a high number of genes this function will take 
# several minutes to compute.

groupsVector <- SummarizedExperiment::colData(seBRCA)$ER.IHC

set.seed(5)
ex_prefilterSAM <- prefilterSAM(seBRCA, groupsVector, iter = 25)

# NOTE: For consistent results with the vignettes and example data, use 
# default parameters (e.g., iter = 100).

}
\references{
\itemize{
  \item{\insertRef{schwender2025siggenes}{asuri}}
  \item{\insertRef{martinezromero2018}{asuri}} 
  \item{\insertRef{BuenoFortes2023}{asuri}}
}
}
