% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/18_mixmod_bin_densities.R
\name{mclust_breaks}
\alias{mclust_breaks}
\alias{mixtools_breaks}
\alias{quantile_breaks}
\title{Mixture/Quantile breaks}
\usage{
mclust_breaks(x, k = NULL)

mixtools_breaks(x, k = 2)

quantile_breaks(x, k = 3, probs = seq_len(k - 1)/k)
}
\arguments{
\item{x}{numeric}

\item{k}{number}

\item{probs}{probabilities}
}
\description{
Mixture/Quantile breaks
}
\examples{
set.seed(1)
x <- c(rnorm(20, 3), rnorm(20,7), rnorm(20, 11))
  mclust_breaks(x)
mixtools_breaks(x, k = 3)
quantile_breaks(x)
}
