% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/18_mixmod_bin_densities.R
\name{plot_x_density}
\alias{plot_x_density}
\alias{plot_y_density}
\alias{plot_xy_scatter}
\alias{plot_xy_density}
\title{Plot xy densities}
\usage{
plot_x_density(
  x,
  y = NULL,
  xbreaks = mclust_breaks(x),
  components = TRUE,
  title = NULL,
  color = "#F8766D",
  xlab = NULL,
  ylab = "Density",
  transcolor = "00000000",
  panel.border = element_rect(color = color),
  plot.margin = unit(c(5.5, 5.5, 5.5, 5.5), "points"),
  scale_x_position = "bottom",
  axis.ticks.x = element_line(color = color),
  axis.ticks.y = element_line(color = color),
  axis.text.x = element_text(color = color),
  axis.text.y = element_text(color = color),
  axis.title.y = element_text(color = color)
)

plot_y_density(
  y,
  x = NULL,
  ybreaks = mclust_breaks(y),
  title = NULL,
  color = "#F8766D",
  xlab = NULL,
  ylab = NULL,
  transcolor = "00000000"
)

plot_xy_scatter(
  x,
  y,
  xbreaks = mclust_breaks(x),
  ybreaks = mclust_breaks(y),
  color = c("#F8766D", "#00BFC4"),
  contour = FALSE,
  smooth = FALSE,
  xlab = NULL,
  ylab = NULL
)

plot_xy_density(
  x,
  y,
  xbreaks = mclust_breaks(x),
  ybreaks = mclust_breaks(y),
  xlab = get_name_in_parent(x),
  ylab = get_name_in_parent(y),
  color = c("#F8766D", "#00BFC4"),
  contour = FALSE,
  smooth = FALSE
)
}
\arguments{
\item{x}{numeric vector}

\item{y}{numeric vector}

\item{xbreaks}{numeric vector}

\item{components}{TRUE or FALSE: whether to plot distributions of mixture components}

\item{title}{NULL or string}

\item{color}{vector or string}

\item{xlab}{NULL or string}

\item{ylab}{NULL or string}

\item{transcolor}{string}

\item{panel.border}{element_rect(color = color)  etc.}

\item{plot.margin}{unit(c(5.5,5.5,5.5,5.5), 'points')  etc.}

\item{scale_x_position}{'bottom' etc.}

\item{axis.ticks.x}{element_line(color = color) etc.}

\item{axis.ticks.y}{element_line(color = color) etc.}

\item{axis.text.x}{element_text(color = color) etc.}

\item{axis.text.y}{element_text(color = color) etc.}

\item{axis.title.y}{element_text(color = color) etc.}

\item{ybreaks}{numeric vector}

\item{contour}{TRUE or FALSE: plot density contours ?}

\item{smooth}{TRUE or FALSE: plot smooth line ?}
}
\value{
ggplot
}
\description{
Plot xy densities
}
\examples{
# Bimodal
    set.seed(1)
    x <- c(rnorm(10, 3), rnorm(10,7))
    y <- c(rnorm(10, 3), rnorm(10,7))
    plot_xy_density(x,y)
    plot_xy_density(x,y, contour = TRUE)
    plot_xy_density(x,y,  smooth = TRUE)
    plot_xy_scatter(x,y)
    plot_x_density(x)
    plot_y_density(y)
# Unimodal
    set.seed(1)
    x <- c(rnorm(20, 3))
    y <- c(rnorm(20, 3))
    plot_xy_density(x,y)
    plot_xy_scatter(x,y)
    plot_x_density(x)
    plot_y_density(y)
}
