% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandle-utils.R
\name{kldirpg}
\alias{kldirpg}
\alias{kldir}
\alias{prior_pred_dir}
\alias{prior_pred_pg}
\title{Computes the Kullback-Leibler divergence between Polya-Gamma and
Dirichlet priors}
\usage{
kldirpg(sigma = diag(1, 1, 1), mu = c(0, 0, 0), alpha = c(1))

kldir(alpha, beta)

prior_pred_dir(object, fcol = "markers", iter = 5000, dirPrior = NULL, q = 15)

prior_pred_pg(
  objectCond1,
  objectCond2,
  fcol = "markers",
  tau = 0.2,
  lambda = 0.01,
  mu_prior = NULL,
  iter = 10000,
  q = 15
)
}
\arguments{
\item{sigma}{the sigma parameter of the Polya-Gamma prior. A positive-definite
symmetric matrix.}

\item{mu}{the mu parameter of the Polya-Gamma prior. A vector of means}

\item{alpha}{The concentration parameter of the first Dirichlet distribution}

\item{beta}{The concentration parameter of the second Dirichlet distribution}

\item{object}{An instance of class \code{MSnSet}}

\item{fcol}{The feature column indiating the markers. Default is "markers"}

\item{iter}{Number of sample to use from prior predictive distribution.
Default is 10000}

\item{dirPrior}{The Dirichlet prior used. If NULL (default) will generate a
a default Dirichlet prior. This should be a matrix with the same dimensions
as the number of subcellular niches. The diagonal terms correspond
to the prior probability of not differentially localising. The (i,j)
term corresponds to prior probability of differntially localising between
niche i and j.}

\item{q}{The upper tail value. That is the prior probability of having more
than q differential localisations. Default is 15.}

\item{objectCond1}{An instance of class \code{MSnSet}, usually the control dataset}

\item{objectCond2}{An instance of class \code{MSnSet}, usually the treatment dataset}

\item{tau}{The \code{tau} parameter of the Polya-Gamma prior. Default is 0.2.}

\item{lambda}{The \code{lambda} ridge parameter used for numerical stability.
Default is 0.01}

\item{mu_prior}{The mean of the Polya-Gamma prior. Default is NULL which generates
a default Polya-Gamma prior.}
}
\value{
returns a numeric indicating the KL divergence

a numeric indicating the KL divergence

A list contain the prior predictive distribution of
differential localisations, the mean number of differential localised proteins
and the probability than more than q are differentially localised

A list contain the prior predictive distribution of
differential localisations, the mean number of differential localised proteins
and the probability than more than q are differentially localised
}
\description{
Computes the Kullback-Leibler divergence between Polya-Gamma and
Dirichlet priors

Compute the KL divergence between two Dirichlet distributions

A function to compute the prior predictive distribution of the
Dirichlet prior.

A function to compute the prior predictive distribution of the
Polya-Gamma prior.
}
\examples{
kldirpg(sigma = diag(c(1,1,1)), mu = c(0,0,0), alpha = 1)

kldir(c(1,1), c(3,1))

library(pRolocdata)
data("tan2009r1")

out <- prior_pred_dir(object = tan2009r1)

library(pRolocdata)
data("tan2009r1")
set.seed(1)
tansim <- sim_dynamic(object = tan2009r1, 
                    numRep = 6L,
                   numDyn = 100L)
d1 <- tansim$lopitrep
control1 <- d1[1:3]
treatment1 <- d1[4:6]
out <- prior_pred_pg(objectCond1 = control1[[1]],
objectCond2 = treatment1[[1]])


}
