% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tagTopBarcodes.R
\name{tagTopBarcodes}
\alias{tagTopBarcodes}
\title{Tag each Barcode as being part of the major contributors or not}
\usage{
tagTopBarcodes(
  barbieQ,
  activeSamples = NULL,
  proportionThreshold = 0.99,
  nSampleThreshold = 1
)
}
\arguments{
\item{barbieQ}{A \code{SummarizedExperiment} object created by the \link{createBarbieQ} function.}

\item{activeSamples}{A logical vector indicating individual samples (columns)
to consider or avoid when determining the \emph{top} Barcodes across the entire
dataset. Default to considering all samples in the \code{barbieQ} object.}

\item{proportionThreshold}{A numeric value ranging from 0 to 1,
used as a threshold for determining \emph{top} Barcodes in each sample
based on their combined proportion in theat sample. Default to 0.99.}

\item{nSampleThreshold}{An integer specifying the minimum number of times
a Barcode must be tagged as \emph{top} across the selected samples
(specified by \code{activeSamples}) in order to be considered \emph{top}
for the entire dataset. Default to 1.}
}
\value{
A \code{barbieQ} object with slots \code{isTopAssay} and \code{isTopBarcode} added or updated,
while inheriting other components from the \code{barbieQ} object passed into the function.
See \code{barbieQ} structure (as a \code{SummarizedExperiment} object) in \link{createBarbieQ}.
\itemize{
\item \code{isTopAssay}: a logical matrix stored in \code{assays(barbieQ)}
tagging Barcodes as \emph{top} in each sample.
\item \code{isTopBarcode}: a \code{DataFrame} stored in \code{rowData(barbieQ)}
with a single logical column tagging Barcodes as \emph{top} or not across the entire dataset.
}
}
\description{
\code{tagTopBarcodes()} tags \emph{top} Barcodes that collectively contribute to
the majority of counts across the dataset.
It is designed for subsequently filtering out the background noise,
i.e., filtering out Barcodes that consistently have low contributions across samples.
In each sample, Barcodes are tagged as major contributing Barcodes
(\emph{top} Barcodes) or not, based on whether their
combined proportion passes a defined threshold in the sample.
Across the entire dataset, a Barcode is considered \emph{top}
if it is tagged as \emph{top} in a number of samples,
meeting a specified appearance threshold across all selected samples.
}
\examples{
## create a `barbieQ` object
## sample conditions and color palettes
sampleConditions <- data.frame(
  Treat = factor(rep(c('ctrl', 'drug'), each = 6)),
  Time = rep(rep(seq_len(2), each = 3), 2)
)
conditionColor <- list(
  Treat = c(ctrl = '#999999', drug = '#112233'),
  Time = c('1' = '#778899', '2' = '#998877')
)
## Barcode count data
nbarcodes <- 50
nsamples <- 12
barcodeCount <- abs(matrix(rnorm(nbarcodes * nsamples), nbarcodes, nsamples))
rownames(barcodeCount) <- paste0('Barcode', seq_len(nbarcodes))
## create a `barbieQ` object
myBarbieQ <- createBarbieQ(barcodeCount, sampleConditions, conditionColor)
## tag top Barcodes
tagTopBarcodes(myBarbieQ)
}
