% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correctExperiments.R
\name{correctExperiments}
\alias{correctExperiments}
\title{Correct SingleCellExperiment objects}
\usage{
correctExperiments(
  ...,
  batch = NULL,
  restrict = NULL,
  subset.row = NULL,
  correct.all = FALSE,
  assay.type = "logcounts",
  PARAM = FastMnnParam(),
  combine.assays = NULL,
  combine.coldata = NULL,
  include.rowdata = TRUE,
  add.single = TRUE
)
}
\arguments{
\item{...}{One or more \linkS4class{SingleCellExperiment} objects.
If multiple objects are supplied, each object is assumed to contain all and only cells from a single batch.
If a single object is supplied, \code{batch} should also be specified.

Alternatively, one or more lists of SingleCellExperiments can be provided;
this is flattened so that it is as if the objects inside were passed directly to \code{...}.}

\item{batch}{A factor specifying the batch of origin for each cell if only one batch is supplied in \code{...}.
This will be ignored if two or more batches are supplied.}

\item{restrict}{A list of length equal to the number of objects in \code{...}.
Each entry of the list corresponds to one batch and specifies the cells to use when computing the correction.}

\item{subset.row}{A vector specifying the subset of genes to use for correction.
Defaults to \code{NULL}, in which case all genes are used.}

\item{correct.all}{A logical scalar indicating whether to return corrected expression values for all genes, even if \code{subset.row} is set.
Used to ensure that the output is of the same dimensionality as the input.}

\item{assay.type}{A string or integer scalar specifying the assay to use for correction.}

\item{PARAM}{A \linkS4class{BatchelorParam} object specifying the batch correction method to dispatch to, and the parameters with which it should be run.
\linkS4class{ClassicMnnParam} will dispatch to \code{\link{mnnCorrect}};
\linkS4class{FastMnnParam} will dispatch to \code{\link{fastMNN}};
\linkS4class{RescaleParam} will dispatch to \code{\link{rescaleBatches}};
and \linkS4class{RegressParam} will dispatch to \code{\link{regressBatches}}.}

\item{combine.assays}{Character vector specifying the assays from each entry of \code{...} to combine together without correction.
By default, any named assay that is present in all entries of \code{...} is combined.
This can be set to \code{character(0)} to avoid combining any assays.}

\item{combine.coldata}{Character vector specifying the column metadata fields from each entry of \code{...} to combine together.
By default, any column metadata field that is present in all entries of \code{...} is combined.
This can be set to \code{character(0)} to avoid combining any metadata.}

\item{include.rowdata}{Logical scalar indicating whether the function should attempt to include \code{\link{rowRanges}}.}

\item{add.single}{Logical scalar indicating whether merged fields should be added to the original SingleCellExperiment.
Only relevant when a single object is provided in \code{...}.
If \code{TRUE}, \code{combine.assays}, \code{combine.coldata} and \code{include.rowdata} are ignored.}
}
\value{
A SingleCellExperiment containing the merged expression values in the first assay
and a \code{batch} column metadata field specifying the batch of origin for each cell,
as described in \code{\link{batchCorrect}}.
}
\description{
Apply a correction to multiple \linkS4class{SingleCellExperiment} objects,
while also combining the assay data and column metadata for easy downstream use.
This augments the simpler \code{\link{batchCorrect}} function, which returns only the corrected values.
}
\details{
This function makes it easy to retain information from the original SingleCellExperiment objects in the post-merge object.
Operations like differential expression analyses can be easily performed on the uncorrected expression values,
while common annotation can be leveraged in cell-based analyses like clustering.
\itemize{
\item All assays shared across the original objects are \code{cbind}ed and added to the merged object.
This can be controlled with \code{combine.assays}.
Any original assay with the same name as an assay in the output of \code{\link{batchCorrect}} will be ignored with a warning.
\item Any column metadata fields that are shared will also be included in the merged object.
This can be controlled with \code{combine.coldata}.
If any existing field has the same name as any \code{\link{colData}} field produced by \code{\link{batchCorrect}},
it will be ignored in favor of the latter.
\item Row metadata from \code{...} is included in the merged object if \code{include.rowdata=TRUE}.
In such cases, only non-conflicting row data fields are preserved,
i.e., fields with different names or identically named fields with the same values between objects in \code{...}.
Any conflicting fields are ignored with a warning.
\code{rowRanges} are only preserved if they are identical (ignoring the \code{\link{mcols}}) for all objects in \code{...}.
}

If a single SingleCellExperiment object was supplied in \code{...}, the default behavior is to prepend all \code{\link{assays}}, \code{\link{reducedDims}}, \code{\link{colData}}, \code{\link{rowData}} and \code{\link{metadata}} fields from the merged object into the original (removing any original entries with names that overlap those of the merged object).
This is useful as it preserves all (non-overlapping) aspects of the original object, especially the reduced dimensions that cannot, in general, be sensibly combined across multiple objects.
Setting \code{add.single=FALSE} will force the creation of a new SingleCellExperiment rather than prepending.
}
\examples{
sce1 <- scuttle::mockSCE()
sce1 <- scuttle::logNormCounts(sce1)
sce2 <- scuttle::mockSCE()
sce2 <- scuttle::logNormCounts(sce2)

f.out <- correctExperiments(sce1, sce2)
colData(f.out)
assayNames(f.out)

}
\seealso{
\code{\link{batchCorrect}}, which does the correction inside this function.

\code{\link{noCorrect}}, for another method to combine uncorrected assay values.
}
\author{
Aaron Lun
}
