% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noCorrect.R
\name{noCorrect}
\alias{noCorrect}
\title{No correction}
\usage{
noCorrect(
  ...,
  batch = NULL,
  subset.row = NULL,
  correct.all = FALSE,
  assay.type = "logcounts"
)
}
\arguments{
\item{...}{One or more log-expression matrices where genes correspond to rows and cells correspond to columns.
Alternatively, one or more \linkS4class{SingleCellExperiment} objects can be supplied containing a log-expression matrix in the \code{assay.type} assay.
Each object should contain the same number of rows, corresponding to the same genes in the same order.
Objects of different types can be mixed together.

If multiple objects are supplied, each object is assumed to contain all and only cells from a single batch.
If a single object is supplied, it is assumed to contain cells from all batches, so \code{batch} should also be specified.

Alternatively, one or more lists of matrices or SingleCellExperiments can be provided;
this is flattened as if the objects inside each list were passed directly to \code{...}.}

\item{batch}{A vector or factor specifying the batch of origin for all cells when only a single object is supplied in \code{...}.
This is ignored if multiple objects are present.}

\item{subset.row}{A vector specifying which features to use for correction.}

\item{correct.all}{Logical scalar indicating whether corrected expression values should be computed for genes not in \code{subset.row}.
Only relevant if \code{subset.row} is not \code{NULL}.}

\item{assay.type}{A string or integer scalar specifying the assay containing the log-expression values.
Only used for SingleCellExperiment inputs.}
}
\value{
A \linkS4class{SingleCellExperiment} is returned where each row is a gene and each column is a cell. 
This contains:
\itemize{
\item A \code{merged} matrix in the \code{assays} slot, containing the merged expression values from all elements of \code{...}.
\item A \code{batch} column in the \code{colData} slot, containing the batch of origin for each row (i.e., cell) in \code{corrected}.
}
}
\description{
Provides a no-correction method that has the same interface as the correction functions.
This allows users to easily swap function calls to examine the effect of correction.
}
\details{
This function is effectively equivalent to \code{cbind}ing the matrices together without any correction.
The aim is to provide a consistent interface that allows users to simply combine batches without additional operations. 
This is often desirable as a negative control to see if the transformation is actually beneficial.
It also allows for convenient downstream analyses that are based on the uncorrected data, e.g., differential expression.

Setting \code{correct.all=TRUE} is equivalent to forcing \code{subset.row=NULL},
given that no correction is being performed anyway.

In the case of a single object in \code{...},
\code{batch} has no effect beyond being stored in the \code{\link{colData}} of the output.
}
\examples{
B1 <- matrix(rnorm(10000), ncol=50) # Batch 1 
B2 <- matrix(rnorm(10000), ncol=50) # Batch 2
out <- noCorrect(B1, B2)

# Same as combining the expression values.
stopifnot(all(assay(out)==cbind(B1, B2)))

# Specifies which cell came from which batch:
str(out$batch)
}
\author{
Aaron Lun
}
