% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jsonCodecs.R
\name{bettrFromJSON}
\alias{bettrFromJSON}
\title{Import bettr data from JSON format}
\usage{
bettrFromJSON(file = NULL, json = NULL)
}
\arguments{
\item{file}{Character scalar, path to the JSON file to import.}

\item{json}{Character scalar, JSON string to parse. If provided, \code{file}
is ignored.}
}
\value{
A \code{SummarizedExperiment} object that can be passed to
\code{bettr}.
}
\description{
Import bettr data from a standardized JSON format and create a
SummarizedExperiment object using \code{assembleSE}.
}
\examples{
df <- data.frame(Method = c("M1", "M2", "M3"),
                 metric1 = c(1, 2, 3),
                 metric2 = c(3, 1, 2))
bettrSE <- assembleSE(df = df)
json_file <- tempfile(fileext = ".json")
bettrToJSON(bettrSE, file = json_file)
bettrSE_reload <- bettrFromJSON(file = json_file)

}
\author{
Daniel Incicau
}
